<?php
/**
 * Backward compatibility functions.
 *
 * @since 3.6.0
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;

/**
 * WCPBC_Backward_Compatibility class.
 */
class WCPBC_Backward_Compatibility {

	/**
	 * Returns the wrapper product types.
	 *
	 * @return array
	 */
	public static function wrapper_product_types() {
		return function_exists( 'wcpbc_wrapper_product_types' ) ? wcpbc_wrapper_product_types() : WCPBC_Product_Sync::get_parent_product_types();
	}

	/**
	 * Sync the price of the parent products.
	 *
	 * @param array $args Array of arguments.
	 * @param int   $limit Max number or records to be processed.
	 */
	public static function product_price_sync( $args = array(), $limit = 100 ) {
		if ( class_exists( 'WCPBC_Product_Meta_Data' ) ) {
			return;
		}

		WCPBC_Product_Sync::parent_product_price_sync( $args, $limit );
	}

	/**
	 * Built a SELECT CASE expression to uses in order querys
	 *
	 * @param string $field Field name to multiply by exchange rate.
	 * @param array  $rates Array of currency exchange rates.
	 * @return string
	 */
	public static function built_query_case( $field, $rates ) {
		if ( is_callable( [ 'WCPBC_Admin_Legacy_Reports', 'built_query_case' ] ) ) {
			return WCPBC_Admin_Legacy_Reports::built_query_case( $field, $rates );
		}

		$case_ex = ' CASE meta__order_currency.meta_value ';
		foreach ( $rates as $currency => $rate ) {
			$case_ex .= "WHEN '{$currency}' THEN ( {$field} / ({$rate})) ";
		}
		$case_ex .= "ELSE {$field} END ";

		return $case_ex;
	}

	/**
	 * Built a JOIN query expression to uses in order querys.
	 *
	 * @since 1.8.0
	 * @param string $from_table From table name.
	 * @param string $join_type Join type (INNER, LEFT or RIGHT).
	 * @param string $id_field Order ID field. Default "ID".
	 * @return string
	 */
	public static function built_join_meta_currency( $from_table = false, $join_type = 'INNER', $id_field = 'ID' ) {
		if ( is_callable( [ 'WCPBC_Admin_Legacy_Reports', 'built_join_meta_currency' ] ) ) {
			return WCPBC_Admin_Legacy_Reports::built_join_meta_currency( $from_table, $join_type, $id_field );
		}

		global $wpdb;

		$from_table = $from_table ? $from_table : 'posts';
		return ' ' . $join_type . " JOIN {$wpdb->postmeta} AS meta__order_currency ON ( {$from_table}.{$id_field} = meta__order_currency.post_id AND meta__order_currency.meta_key = '_order_currency' ) ";
	}
}

