<?php
/**
 * Register frontend pricing filters.
 *
 * @since 3.7.0
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;

/**
 * WCPBC_Pro_Frontend_Pricing_Filters class.
 */
class WCPBC_Pro_Frontend_Pricing_Filters {

	/**
	 * The single instance of the class.
	 *
	 * @var object;
	 */
	private static $instance = null;

	/**
	 * Register filters array.
	 *
	 * @var array;
	 */
	protected $filters = [];

	/**
	 * Get class instance.
	 *
	 * @return object Instance.
	 */
	final public static function init() {
		if ( null === static::$instance ) {
			static::$instance = new static();
		}
		return static::$instance;
	}

	/**
	 * Prevent cloning.
	 */
	private function __clone() {}

	/**
	 * Prevent unserializing.
	 */
	final public function __wakeup() {
		wc_doing_it_wrong( __FUNCTION__, __( 'Unserializing instances of this class is forbidden.', 'wc-price-based-country-pro' ), '3.7' );
		die();
	}

	/**
	 * Constructor
	 *
	 * @return void
	 */
	protected function __construct() {
		$this->filters = [];
		$this->init_hooks();
	}

	/**
	 * Init hooks
	 */
	protected function init_hooks() {
		add_action( 'wc_price_based_country_frontend_princing_init', [ $this, 'add_filters' ] );
		add_action( 'wc_price_based_country_frontend_princing_unset', [ $this, 'remove_filters' ] );
	}

	/**
	 * Register a frontend pricing filter.
	 *
	 * @param string   $hook_name     The name of the filter to add the callback to.
	 * @param callable $callback      The callback to be run when the filter is applied.
	 * @param int      $priority      Optional. Used to specify the order in which the functions associated with a particular filter are executed.
	 * @param int      $accepted_args Optional. The number of arguments the function accepts. Default 1.
	 */
	public function register_filter( $hook_name, $callback, $priority = 10, $accepted_args = 1 ) {
		$this->filters[] = [ $hook_name, $callback, $priority, $accepted_args ];
	}

	/**
	 * Add filters.
	 */
	public function add_filters() {
		foreach ( $this->filters as $filter ) {
			add_filter( ...$filter );
		}
	}

	/**
	 * Remove filters.
	 */
	public function remove_filters() {
		foreach ( $this->filters as $filter ) {
			remove_filter( ...$filter );
		}
	}
}
