<?php
/**
 * Recurring actions handler. Schedule action that runs at specific time.
 * Do no requires removing the schedule on plugin deactivation.
 *
 * @since 3.6.0
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;

/**
 * WCPBC_Recurring_Actions Class
 */
class WCPBC_Recurring_Actions {

	/**
	 * Recurring actions.
	 *
	 * @var array
	 */
	private static $data = [];

	/**
	 * Init.
	 */
	public static function init() {
		self::set_data();
		self::init_hooks();
	}

	/**
	 * Sets the recurring actions
	 */
	private static function set_data() {
		self::$data = [
			'wc_price_based_country_weekly_job' => '+1 week',
			'wc_price_based_country_pro_update_exchange_rates' => sprintf( 'tomorrow 2:00 am %s', wp_timezone_string() ),
		];
	}

	/**
	 * Hook actions and filters
	 */
	private static function init_hooks() {
		add_action( 'admin_init', [ __CLASS__, 'install' ] );
		foreach ( self::$data as $hook => $time ) {
			add_action( $hook, [ __CLASS__, 'schedule_again' ], 999 );
		}
	}

	/**
	 * Schedule the actions.
	 */
	public static function install() {
		if ( ! function_exists( 'as_next_scheduled_action' ) ) {
			return;
		}

		$has_scheduled_action = function_exists( 'as_has_scheduled_action' ) ? 'as_has_scheduled_action' : 'as_next_scheduled_action';

		foreach ( self::$data as $hook => $time ) {
			if ( false !== call_user_func( $has_scheduled_action, $hook ) ) {
				continue;
			}

			as_schedule_single_action( strtotime( $time ), $hook );
		}
	}

	/**
	 * Schedule the action on shutdown.
	 */
	public static function schedule_again() {
		add_action( 'shutdown', [ __CLASS__, 'install' ] );
	}
}
