<?php
/**
 * Extend the Variable_Cart_Items variable to display the correct prices and currency.
 *
 * @since 3.4.6
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;

/**
 * Variable {{ cart.items }} class.
 *
 * WCPBC_Automatewoo_Variable_Cart_Items class
 */
class WCPBC_Automatewoo_Variable_Cart_Items extends \AutomateWoo\Variable_Cart_Items {

	/**
	 * Current cart currency
	 *
	 * @var string.
	 */
	protected $currency = false;

	/**
	 * Get product html to display.
	 *
	 * @param string $template Template.
	 * @param array  $args Array of arguments.
	 *
	 * @return string
	 */
	public function get_product_display_html( $template, $args = [] ) {

		if ( empty( $args['cart'] ) ) {
			return '';
		}

		$cart_items = $args['cart']->get_items();
		$products   = [];

		foreach ( $cart_items as $item ) {

			$product = $item->get_product();
			$data    = $item->get_data();

			if ( is_a( $product, 'WC_Product' ) && $product->get_status() === 'publish' ) {

				if ( isset( $data['product_prices'] ) ) {

					$prices = array_map( 'floatval', $data['product_prices'] );

					// Force the property update.
					$product->set_price( -9999 );
					$product->set_regular_price( -9999 );
					$product->set_sale_price( -9999 );

					// Update with the real prices.
					$product->set_price( $prices['price'] );
					$product->set_regular_price( $prices['regular_price'] );

					if ( $prices['price'] < $prices['regular_price'] ) {
						$product->set_sale_price( $prices['price'] );
					} else {
						$product->set_sale_price( '' );
					}

					if ( isset( $prices['subscription_sign_up_fee'] ) && is_callable( [ 'WC_Subscriptions_Product', 'is_subscription' ] ) && WC_Subscriptions_Product::is_subscription( $product ) ) {
						$product->update_meta_data(
							'_subscription_sign_up_fee',
							-9999
						);

						$product->update_meta_data(
							'_subscription_sign_up_fee',
							$prices['subscription_sign_up_fee']
						);
					}
				}

				$products[] = $product;
			}
		}

		$args['products'] = $products;

		$this->currency = $args['cart']->get_currency();

		add_filter( 'woocommerce_currency', [ $this, 'get_cart_currency' ], 999999 );

		$product_display_html = parent::get_product_display_html( $template, $args );

		remove_filter( 'woocommerce_currency', [ $this, 'get_cart_currency' ], 999999 );

		$this->currency = false;

		return $product_display_html;
	}

	/**
	 * Returns the cart currency.
	 */
	public function get_cart_currency() {
		return $this->currency;
	}
}
