<?php
/**
 * WP All Import product options.
 *
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;
?>
<style>
	#wcpbc-wpallimport-metabox .wpallimport-collapsed-content-inner h4 {
		cursor:pointer;
	}

	#wcpbc-wpallimport-metabox .wpallimport-collapsed-content-inner h4:before{
		display:inline-block;
		content: "\f347";
		font-family: dashicons;
		display: inline-block;
		line-height: 1;
		font-weight: 400;
		font-style: normal;
		margin-right: 2px;
		font-size: 1.3em;
		vertical-align: bottom;
	}

	#wcpbc-wpallimport-metabox .wpallimport-collapsed-content-inner h4.expanded:before {
		content: "\f343";
	}

	#wcpbc-wpallimport-metabox .form-field label {
		margin: 0.25em 0 0.5em 0;
	}

	#wcpbc-wpallimport-metabox .form-field.wcpbc-wpallimport-text-field label {
		display: block;
	}

	#wcpbc-wpallimport-metabox .wcpbc-wpallimport-col-2 {
		display: flex;
		width: 100%;
	}

	#wcpbc-wpallimport-metabox .wcpbc-wpallimport-col-2 .input {
		width: 50%;
	}
</style>
<div class="wpallimport-collapsed closed" id="wcpbc-wpallimport-metabox">
	<div class="wpallimport-content-section">
		<div class="wpallimport-collapsed-header">
			<h3>Price Based on Country Add-On</h3>
		</div>
		<div class="wpallimport-collapsed-content" style="padding:0;">
			<div class="wpallimport-collapsed-content-inner">
				<?php foreach ( WCPBC_Pricing_Zones::get_zones() as $zone ) : // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals ?>
					<h4 class="wcpbc-allimport-title -title-<?php echo esc_attr( $zone->get_id() ); ?><?php echo ( 'exchange_rate' === self::get_post_value( $post, '_price_method', $zone ) ? ' expanded' : '' ); ?>"><?php echo esc_html( wcpbc_price_method_label( __( 'Price for', 'wc-price-based-country-pro' ), $zone ) ); ?></h4>
					<div class="wcpbc-allimport-fields -fields-<?php echo esc_attr( $zone->get_id() ); ?>">
						<?php
							include dirname( __FILE__ ) . '/main/price-mode.php';
							include dirname( __FILE__ ) . '/main/regular-sale-price.php';
							include dirname( __FILE__ ) . '/main/sale-price-dates.php';
						?>
					</div>
				<?php endforeach; ?>
			</div>
		</div>
	</div>
</div>
<script>
;( function( $ ) {
	$('#wcpbc-wpallimport-metabox h4.wcpbc-allimport-title').on('click', function(){
		let target = '.' + $(this).attr('class').replace(/-title/g, '-fields').replace(' ', '.').replace('expanded', '');
		$(this).toggleClass('expanded');
		$(target).toggle( $(this).hasClass('expanded') );
	});

	$(document).ready(function(){
		$('#wcpbc-wpallimport-metabox h4.wcpbc-allimport-title').each(function() {
			$(this).triggerHandler('click');
		});
	});
})( jQuery );
</script>
