<?php
/**
 * WP All Import pricing zone options.
 *
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;
?>

<?php foreach ( wcpbc_price_method_options() as $key => $label ) : // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals ?>
	<div class="input">
		<p class="form-field wpallimport-radio-field">
			<input type="radio" id="<?php echo esc_attr( sanitize_title( self::get_option_name( '_price_method', $zone ) ) . '_' . $key ); ?>" name="<?php echo esc_attr( self::get_option_name( '_price_method', $zone ) ); ?>" value="<?php echo esc_attr( $key ); ?>" <?php checked( self::get_post_value( $post, '_price_method', $zone ), $key ); ?> class="switcher<?php echo ( 'exchange_rate' === $key ? ' switcher-reversed' : '' ); ?>"/>
			<label for="<?php echo esc_attr( sanitize_title( self::get_option_name( '_price_method', $zone ) ) . '_' . $key ); ?>"><?php echo wp_kses_post( $label ); ?></label>
		</p>
	</div>
<?php endforeach; ?>
<div class="form-field wpallimport-radio-field">
	<input type="radio" id="<?php echo esc_attr( sanitize_title( self::get_option_name( '_price_method', $zone ) ) . '_xpath' ); ?>" class="switcher" name="<?php echo esc_attr( self::get_option_name( '_price_method', $zone ) ); ?>" value="xpath" <?php checked( self::get_post_value( $post, '_price_method', $zone ), 'xpath' ); ?>/>
	<label for="<?php echo esc_attr( sanitize_title( self::get_option_name( '_price_method', $zone ) ) . '_xpath' ); ?>"><?php esc_html_e( 'Set with XPath', 'wc-price-based-country-pro' ); ?></label>
	<div class="switcher-target-<?php echo esc_attr( sanitize_title( self::get_option_name( '_price_method', $zone ) ) . '_xpath' ); ?> set_with_xpath">
		<span class="wpallimport-slide-content" style="padding-left:0;">
			<input type="text" class="smaller-text" name="<?php echo esc_attr( self::get_option_name( '_price_method_xpath', $zone ) ); ?>" style="width:300px;" value="<?php echo esc_attr( self::get_post_value( $post, '_price_method_xpath', $zone ) ); ?>">
			<a href="#help" style="top:0;" class="wpallimport-help" aria-describedby="tipsy" title="<?php esc_attr_e( "The value of presented XPath should be one of the following: ('manual', 'exchange_rate').", 'wc-price-based-country-pro' ); ?>" tabindex="0">?</a>
		</span>
	</div>
</div>
