<?php
/**
 * WP All Import pricing zone options.
 *
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;
?>
<div class="switcher-target-<?php echo esc_attr( sanitize_title( self::get_option_name( '_price_method', $zone ) ) . '_exchange_rate' ); ?>">
	<p class="form-field">
		<label><?php esc_html_e( 'Sale price dates', 'wc-price-based-country-pro' ); ?></label>
	</p>
	<div class="input">
		<p class="form-field wpallimport-radio-field">
			<input type="radio" id="<?php echo esc_attr( sanitize_title( self::get_option_name( '_sale_price_dates', $zone ) ) . '_default' ); ?>" class="switcher switcher-reversed" name="<?php echo esc_attr( self::get_option_name( '_sale_price_dates', $zone ) ); ?>" value="default" <?php checked( self::get_post_value( $post, '_sale_price_dates', $zone ), 'default' ); ?>/>
			<label for="<?php echo esc_attr( sanitize_title( self::get_option_name( '_sale_price_dates', $zone ) ) . '_default' ); ?>"><?php echo wp_kses_post( __( 'Same as default price', 'wc-price-based-country-pro' ) ); ?></label>
		</p>
	</div>
	<div class="input">
		<p class="form-field wpallimport-radio-field">
			<input type="radio" id="<?php echo esc_attr( sanitize_title( self::get_option_name( '_sale_price_dates', $zone ) ) . '_manual' ); ?>" class="switcher" name="<?php echo esc_attr( self::get_option_name( '_sale_price_dates', $zone ) ); ?>" value="manual" <?php checked( self::get_post_value( $post, '_sale_price_dates', $zone ), 'manual' ); ?>/>
			<label for="<?php echo esc_attr( sanitize_title( self::get_option_name( '_sale_price_dates', $zone ) ) . '_manual' ); ?>"><?php echo wp_kses_post( __( 'Set specific dates', 'wc-price-based-country-pro' ) ); ?></label>
		</p>
	</div>
	<div class="form-field wpallimport-radio-field">
		<input type="radio" id="<?php echo esc_attr( sanitize_title( self::get_option_name( '_sale_price_dates', $zone ) ) . '_xpath' ); ?>" class="switcher" name="<?php echo esc_attr( self::get_option_name( '_sale_price_dates', $zone ) ); ?>" value="xpath" <?php checked( self::get_post_value( $post, '_sale_price_dates', $zone ), 'xpath' ); ?>/>
		<label for="<?php echo esc_attr( sanitize_title( self::get_option_name( '_sale_price_dates', $zone ) ) . '_xpath' ); ?>"><?php esc_html_e( 'Set with XPath', 'wc-price-based-country-pro' ); ?></label>
		<div class="switcher-target-<?php echo esc_attr( sanitize_title( self::get_option_name( '_sale_price_dates', $zone ) ) . '_xpath' ); ?> set_with_xpath">
			<span class="wpallimport-slide-content" style="padding-left:0;">
				<input type="text" class="smaller-text" name="<?php echo esc_attr( self::get_option_name( '_sale_price_dates_xpath', $zone ) ); ?>" style="width:300px;" value="<?php echo esc_attr( self::get_post_value( $post, '_sale_price_dates_xpath', $zone ) ); ?>">
				<a href="#help" style="top:0;" class="wpallimport-help" aria-describedby="tipsy" title="<?php esc_attr_e( "The value of presented XPath should be one of the following: ('manual', 'default').", 'wc-price-based-country-pro' ); ?>" tabindex="0">?</a>
			</span>
		</div>
	</div>
	<div class="input switcher-target-<?php echo esc_attr( sanitize_title( self::get_option_name( '_sale_price_dates', $zone ) ) . '_default' ); ?>">
		<p class="form-field">
			<span style="display:inline-block;vertical-align:middle">
				<span><?php echo esc_html( _x( 'From', 'placeholder', 'wc-price-based-country-pro' ) ); ?></span>
				<input type="text" class="datepicker" name="<?php echo esc_attr( self::get_option_name( '_sale_price_dates_from', $zone ) ); ?>" value="<?php echo esc_attr( self::get_post_value( $post, '_sale_price_dates_from', $zone ) ); ?>" style="float:none; width:120px;"/>
				<span><?php echo esc_html( _x( 'To', 'placeholder', 'wc-price-based-country-pro' ) ); ?></span>
				<input type="text" class="datepicker" name="<?php echo esc_attr( self::get_option_name( '_sale_price_dates_to', $zone ) ); ?>" value="<?php echo esc_attr( self::get_post_value( $post, '_sale_price_dates_to', $zone ) ); ?>" style="float:none !important; width:120px;"/>
			</span>
		</p>
	</div>
</div>
