<?php
/**
 * WP All Import product options.
 *
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;
?>
<div class="input">
<input type="hidden" name="<?php echo esc_attr( self::get_option_name( 'is_update_pricing_zones' ) ); ?>" value="0" />
	<input type="checkbox" id="<?php echo esc_attr( self::get_option_name( 'is_update_pricing_zones' ) ); ?>" name="<?php echo esc_attr( self::get_option_name( 'is_update_pricing_zones' ) ); ?>" value="1" <?php checked( self::get_post_value( $post, 'is_update_pricing_zones' ), '1' ); ?> class="switcher"/>
	<label for="<?php echo esc_attr( self::get_option_name( 'is_update_pricing_zones' ) ); ?>"><?php esc_html_e( 'Pricing zones (Price Based on Country Add-on)', 'wc-price-based-country-pro' ); ?></label>
</div>
<div class="switcher-target-<?php echo esc_attr( self::get_option_name( 'is_update_pricing_zones' ) ); ?>" style="padding-left: 17px;">
	<div class="input">
		<input type="radio" id="<?php echo esc_attr( self::get_option_name( 'update_pricing_zones_logic' ) . '_full_update' ); ?>" name="<?php echo esc_attr( self::get_option_name( 'update_pricing_zones_logic' ) ); ?>" value="full_update" <?php checked( self::get_post_value( $post, 'update_pricing_zones_logic' ), 'full_update' ); ?> class="switcher"/>
		<label for="<?php echo esc_attr( self::get_option_name( 'update_pricing_zones_logic' ) . '_full_update' ); ?>"><?php esc_html_e( 'Update all Pricing zones', 'wc-price-based-country-pro' ); ?></label>
	</div>
	<div class="input">
		<input type="radio" id="<?php echo esc_attr( self::get_option_name( 'update_pricing_zones_logic' ) . '_only' ); ?>" name="<?php echo esc_attr( self::get_option_name( 'update_pricing_zones_logic' ) ); ?>" value="only" <?php checked( self::get_post_value( $post, 'update_pricing_zones_logic' ), 'only' ); ?> class="switcher"/>
		<label for=""><?php esc_html_e( 'Update only these Pricing zones', 'wc-price-based-country-pro' ); ?></label>
		<div class="switcher-target-<?php echo esc_attr( self::get_option_name( 'update_pricing_zones_logic' ) . '_only' ); ?> pmxi_choosen" style="padding-left:17px;">
			<span class="hidden choosen_values"><?php echo esc_attr( implode( ',', wc_list_pluck( WCPBC_Pricing_Zones::get_zones(), 'get_id' ) ) ); ?></span>
			<input class="choosen_input" value="<?php echo ( 'only' === self::get_post_value( $post, 'update_pricing_zones_logic' ) ? esc_attr( self::get_post_value( $post, 'pricing_zones_only' ) ) : '' ); ?>" type="hidden" name="<?php echo esc_attr( self::get_option_name( 'pricing_zones_only' ) ); ?>"/>
		</div>
	</div>
	<div class="input">
		<input type="radio" id="<?php echo esc_attr( self::get_option_name( 'update_fields_logic' ) . '_full_update' ); ?>" name="<?php echo esc_attr( self::get_option_name( 'update_fields_logic' ) ); ?>" value="full_update" <?php checked( self::get_post_value( $post, 'update_fields_logic' ), 'full_update' ); ?> class="switcher"/>
		<label for="<?php echo esc_attr( self::get_option_name( 'update_fields_logic' ) . '_full_update' ); ?>"><?php esc_html_e( 'Update all fields', 'wc-price-based-country-pro' ); ?></label>
	</div>
	<div class="input">
		<input type="radio" id="<?php echo esc_attr( self::get_option_name( 'update_fields_logic' ) . '_only' ); ?>" name="<?php echo esc_attr( self::get_option_name( 'update_fields_logic' ) ); ?>" value="only" <?php checked( self::get_post_value( $post, 'update_fields_logic' ), 'only' ); ?> class="switcher"/>
		<label for=""><?php esc_html_e( 'Update only these fields', 'wc-price-based-country-pro' ); ?></label>
		<div class="switcher-target-<?php echo esc_attr( self::get_option_name( 'update_fields_logic' ) . '_only' ); ?> pmxi_choosen" style="padding-left:17px;">
			<span class="hidden choosen_values"><?php echo esc_attr( implode( ',', wc_list_pluck( self::get_fields_config(), 'label' ) ) ); ?></span>
			<input class="choosen_input" value="<?php echo ( 'only' === self::get_post_value( $post, 'update_fields_logic' ) ? esc_attr( self::get_post_value( $post, 'fields_only' ) ) : '' ); ?>" type="hidden" name="<?php echo esc_attr( self::get_option_name( 'fields_only' ) ); ?>"/>
		</div>
	</div>
</div>
