<?php
/**
 * Functions.
 *
 * @since 3.7.0
 * @package WCPBC\Functions
 */

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'wcpbc_add_pricing_filter' ) ) {
	/**
	 * Register a frontend pricing filter. Alias for WCPBC_Pro_Frontend_Pricing_Filters::init()->register_filter.
	 *
	 * @see WCPBC_Pro_Frontend_Pricing_Filters
	 *
	 * @param string   $hook_name     The name of the filter to add the callback to.
	 * @param callable $callback      The callback to be run when the filter is applied.
	 * @param int      $priority      Optional. Used to specify the order in which the functions associated with a particular filter are executed.
	 * @param int      $accepted_args Optional. The number of arguments the function accepts. Default 1.
	 */
	function wcpbc_add_pricing_filter( $hook_name, $callback, $priority = 10, $accepted_args = 1 ) {
		if ( ! class_exists( 'WCPBC_Pro_Frontend_Pricing_Filters' ) ) {
			return;
		}

		WCPBC_Pro_Frontend_Pricing_Filters::init()->register_filter( $hook_name, $callback, $priority, $accepted_args );
	}
}
