<?php
/**
 * Currency Switcher template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce-product-price-based-on-countries/currency-switcher.php.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WCPBC/Templates
 * @version 3.0.0
 */

if ( ! defined( 'ABSPATH' ) || empty( $options ) ) {
	exit; // Exit if accessed directly.
}

add_action( 'wp_footer', [ 'WCPBC_Widget_Country_Selector', 'country_switcher_form' ], 5 );
?>
<select form="wcpbc-widget-country-switcher-form" onchange="document.getElementById('wcpbc-widget-country-switcher-input').value=this.value;this.form.submit();" class="wcpbc-currency-switcher currency-switcher wp-exclude-emoji <?php echo esc_attr( apply_filters( 'wc_price_based_country_currency_switcher_class', '' ) ); ?>">
	<?php foreach ( $options as $key => $value ) : // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals ?>
		<option class="wp-exclude-emoji" data-currency="<?php echo esc_attr( $currencies[ $key ] ); ?>" value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $selected_country ); ?> >
			<?php if ( $show_flags ) : ?>
				<?php echo esc_html( WCPBC_Country_Flags::get_by_currency( $currencies[ $key ] ) ); ?>&nbsp;
			<?php endif; ?>
			<?php echo esc_html( $value ); ?>
		</option>
	<?php endforeach; ?>
</select>
