<?php
/**
 * Plugin Name: WooCommerce Price Based on Country Pro
 * Plugin URI: https://www.pricebasedcountry.com/
 * Description: Extends Price Based on Country for WooCommerce with professionals features.
 * Version: 3.7.1
 * Author: Oscar Gare
 * Author URI: https://www.pricebasedcountry.com/
 * Domain Path: /languages/
 * Text Domain: wc-price-based-country-pro
 * Requires PHP: 5.6
 * Requires Plugins: woocommerce-product-price-based-on-countries
 * WC requires at least: 4.0
 * WC tested up to: 10.0
 * License: GPLv2
 *
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;

// Define WCPBC_PRO_PLUGIN_FILE.
if ( ! defined( 'WCPBC_PRO_PLUGIN_FILE' ) ) {
	define( 'WCPBC_PRO_PLUGIN_FILE', __FILE__ );
}

/**
 * Declare plugin compatible with the WooCommerce HPOS feature.
 */
add_action(
	'before_woocommerce_init',
	function() {
		if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	}
);

register_activation_hook(
	WCPBC_PRO_PLUGIN_FILE,
	function() {
		// Welcome screen cookie.
		if ( is_network_admin() || ! ( isset( $_GET['action'] ) && 'activate' === $_GET['action'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification
			return;
		}
		setcookie( '_wcpbc_pro_activation_redirect', '1', time() + HOUR_IN_SECONDS );
	}
);

// Include the main WooCommerce class.
if ( ! class_exists( 'WC_Product_Price_Based_Country_Pro' ) ) {
	include_once dirname( __FILE__ ) . '/includes/class-wc-product-price-based-country-pro.php';
	WC_Product_Price_Based_Country_Pro::init();
}
