;( function( $ ) {

	if ( typeof wcpbc_price_preview_params === 'undefined' ) {
		return false;
	}

	/**
	 * Price preview.
	 */
	 $.fn.wcpbc_price_preview = function() {

		function getPlaceholder($el) {
			let value = $el.attr('placeholder');
			if ( 'undefined' == typeof value ) {
				value = '';
			}
			return value;
		}

		function getCurrencyCode($me) {
			const $currencySel = $( $me.data('preview-currency') ).find('option:selected');
			let currencyCode   = '';

			if ( $currencySel.length ) {
				currencyCode = $currencySel.val();
			}
			return currencyCode;
		}

		function getCurrencySymbol($me) {
			const $currencySel = $( $me.data('preview-currency') ).find('option:selected');
			let currencySymbol = '';

			if ( $currencySel.length ) {
				currencySymbol = $currencySel.text();

				const pos = currencySymbol.lastIndexOf('(');
				if (pos > -1) {
					currencySymbol = currencySymbol.substring(pos+1).replace(')', '');
				}
			}
			return currencySymbol;
		}

		function getCurrencySymbolAlt( $me ) {
			const code = getCurrencyCode( $me );
			let symbolAlt = '';
			if ( typeof wcpbc_price_preview_params.alt_currency_symbols[code] !== 'undefined' ) {
				symbolAlt = wcpbc_price_preview_params.alt_currency_symbols[code];
			} else {
				symbolAlt = getCurrencySymbol($me);
			}
			return symbolAlt;
		}

		function getTrimZeros($me) {
			let value = false;
			const $that = $( $me.data('preview-trim-zeros') );
			if ( $that.length > 0 ) {
				value = $that.val() == 'yes';
			}
			return value;
		}

		function getNumDecimals($me) {

			if ( getTrimZeros($me)) {
				return 0;
			}

			let numDecimals = 0;
			const $numDecimalsInput = $( $me.data('preview-num-decimals') );

			if ( $numDecimalsInput.length ) {
				numDecimals = $numDecimalsInput.val();
				if ( numDecimals.length<1 ) {
					numDecimals = getPlaceholder($numDecimalsInput);
				}
			}
			return parseInt(numDecimals);
		}

		function getDecimalPoint($me) {
			let decimalPoint = '';
			const $decimalPointInput = $( $me.data('preview-decimal-sep') );
			if ( $decimalPointInput.length ) {
				decimalPoint = $decimalPointInput.val();
				if ( decimalPoint.length<1 ) {
					decimalPoint = getPlaceholder($decimalPointInput);
				}
			}
			return decimalPoint;
		}

		function getPrice($me) {
			let price = '99';
			const numDecimals = getNumDecimals($me);
			const decimalSep  = (numDecimals>0) ? getDecimalPoint($me) : '';
			price += decimalSep + '0'.repeat(numDecimals);
			return price;
		}

		function pricePreview( $me ) {
			const $preview = $( $me.data('price-preview') );
			let previewText = $me.val();

			if ( previewText.length<1 ) {
				previewText = getPlaceholder($me);
			}

			if ( previewText.length<1 ) {
				previewText = wcpbc_price_preview_params.default_format;
			}

			if ( previewText.indexOf('[price]') < 0 ) {
				previewText = previewText + '[price]';
			}

			previewText = previewText
				.replace('[price]', getPrice($me))
				.replace('[code]', getCurrencyCode($me))
				.replace('[symbol]', getCurrencySymbol($me))
				.replace('[symbol-alt]', getCurrencySymbolAlt($me));

			$preview.html(previewText);
		}

		$(this).on('change', function(){
			pricePreview( $(this) );
		});

		// Show/Hide the element.
		this.each(function() {

			const $preview = $( $(this).data('price-preview') );
			if ( $preview.length < 1 ) {
				return;
			}
			const $that = $(this);

			['preview-currency', 'preview-num-decimals', 'preview-decimal-sep', 'preview-trim-zeros'].forEach(function(target){
				let $el = $( $that.data(target) );
				if ( $el.length > 0 ){
					$el.on('change', function(){
						$that.triggerHandler('change');
					});
				}
			});

			pricePreview($that);
		});
	}

	$(document).ready(function(){
		$('[data-price-preview]').wcpbc_price_preview();
	});

})( jQuery );