<?php
/**
 * Action trait.
 *
 * @since 3.2.0
 * @package WCPBC
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

trait WCPBC_Automatewoo_Action_Trait {

	/**
	 * Explain to store admin what this action does via a unique title and description.
	 */
	public function load_admin_details() {
		parent::load_admin_details();
		$this->title .= $this->get_title_sufix();
	}

	/**
	 * Returns the title suffix
	 *
	 * @return string
	 */
	protected function get_title_sufix() {
		return ' (' . __( 'compatible with Price Based on Country', 'wc-price-based-country-pro' ) . ')';
	}

	/**
	 * Update the line item cost.
	 *
	 * @param \WCPBC_Pricing_Zone $zone Pricing zone.
	 */
	protected function update_line_cost( $zone ) {
		if ( $this->get_option( 'line_item_cost' ) ) {
			$this->options['line_item_cost'] = $zone->get_exchange_rate_price(
				$this->get_option( 'line_item_cost', true )
			);
		}
	}
}
