<?php
/**
 * X-Rates API provider.
 *
 * @see https://www.x-rates.com/
 * @since 2.3.0
 * @package WCPBC
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WCPBC_XRates' ) ) :

	/**
	 * WCPBC_XRates class
	 */
	class WCPBC_XRates extends WCPBC_Exchange_Rates_Provider {

		/**
		 * Constructor
		 */
		public function __construct() {
			$this->id   = 'xrates';
			$this->name = 'X-Rates';
		}

		/**
		 * Return API endpoint
		 *
		 * @return string
		 */
		protected function get_api_endpoint() {
			return 'https://www.x-rates.com/table/?from=' . strtoupper( $this->from_currency ) . '&amount=1';
		}

		/**
		 * Parse the response and return an array of rates.
		 *
		 * @param string $response API response.
		 * @return array
		 */
		protected function parse_response( $response ) {
			$rates   = array();
			$pattern = sprintf( "/<a href='https?:\/\/www.x-rates.com\/graph\/\?from=%s&amp;to=([A-Z]{3})'>(.+)<\/a>/", $this->from_currency );
			$matches = array();

			if ( preg_match_all( $pattern, $response, $matches ) && isset( $matches[1], $matches[2] ) ) {
				foreach ( $matches[1] as $index => $currency ) {
					if ( ! is_string( $currency ) || empty( $matches[2][ $index ] ) ) {
						continue;
					}
					$rates[ $currency ] = floatval( $matches[2][ $index ] );
				}
			}

			return $rates;
		}
	}

endif;

return new WCPBC_XRates();
