<?php
/**
 * Extend the Action_Subscription_Add_Product action to add the product with the correct prices.
 *
 * @since 3.2.0
 * @package WCPBC
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WCPBC_Automatewoo Class
 */
class WCPBC_Automatewoo_Action_Subscription_Update_Product extends \AutomateWoo\Actions\Subscriptions\UpdateProduct {

	use WCPBC_Automatewoo_Action_Trait;

	/**
	 * Pricing zone of the subscription.
	 *
	 * @var WCPBC_Pricing_Zone
	 */
	protected $zone = false;

	/**
	 * Update a given product as a line item to a given subscription.
	 *
	 * @param \WC_Product      $product Product to update to the subscription.
	 * @param \WC_Subscription $subscription Instance of subscription to update the product to.
	 *
	 * @return bool True if the subscription was edited, false if no change was made.
	 */
	protected function edit_subscription( $product, $subscription ) {
		$this->zone = WCPBC_Pricing_Zones::get_zone_from_order( $subscription );
		return parent::edit_subscription( $product, $subscription );

	}
	/**
	 * Apply action changes to a specific subscription line item.
	 *
	 * @param \WC_Product            $product The line item product.
	 * @param \WC_Order_Item_Product $item    Subscription line item.
	 */
	protected function apply_changes_to_order_line_item( \WC_Product $product, \WC_Order_Item_Product $item ) {
		if ( $this->zone ) {
			$this->update_line_cost( $this->zone );
		}
		parent::apply_changes_to_order_line_item( $product, $item );
	}
}
