<?php
/**
 * Handle integration with AutomateWoo by WooCommerce.
 *
 * @since 3.2.0
 * @package WCPBC
 * @see https://automatewoo.com
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WCPBC_Automatewoo Class
 */
class WCPBC_Automatewoo {

	/**
	 * Check enviroment notice.
	 *
	 * @var string
	 */
	private static $notice = '';

	/**
	 * Hook actions and filters
	 */
	public static function init() {
		add_filter(
			'automatewoo/actions',
			function( $includes ) {
				if (
					isset( $includes['subscription_add_product'], $includes['subscription_update_product'] ) &&
					class_exists( '\AutomateWoo\Action_Subscription_Add_Product' ) &&
					class_exists( '\AutomateWoo\Actions\Subscriptions\UpdateProduct' )
				) {

					if ( ! class_exists( 'WCPBC_Automatewoo_Action_Subscription_Add_Product' ) ) {
						include_once dirname( __FILE__ ) . '/Actions/wcpbc-automatewoo-action-trait.php';
						include_once dirname( __FILE__ ) . '/Actions/class-wcpbc-automatewoo-action-subscription-add-product.php';
						include_once dirname( __FILE__ ) . '/Actions/class-wcpbc-automatewoo-action-subscription-update-product.php';
					}

					$includes['wcpbc_subscription_add_product']    = WCPBC_Automatewoo_Action_Subscription_Add_Product::class;
					$includes['wcpbc_subscription_update_product'] = WCPBC_Automatewoo_Action_Subscription_Update_Product::class;
				}
				return $includes;
			}
		);

		add_filter(
			'automatewoo/cart/price_args',
			function( $args, $cart ) {
				if ( is_callable( [ $cart, 'get_currency' ] ) ) {
					$args['currency'] = $cart->get_currency();
				}
				return $args;
			},
			10,
			2
		);
	}

	/**
	 * Checks the environment for compatibility problems.
	 *
	 * @return boolean
	 */
	public static function check_environment() {
		$plugin_version = defined( 'AUTOMATEWOO_VERSION' ) ? AUTOMATEWOO_VERSION : 'unknown';
		$min_version    = '5.6.8';

		if ( 'unknown' === $plugin_version || version_compare( $plugin_version, $min_version, '<' ) ) {
			// translators: 1: HTML tag, 2: HTML tag, 3: Product Bundles version.
			self::$notice = sprintf( __( '%1$sPrice Based on Country Pro & AutomateWoo%2$s compatibility requires AutomateWoo +%4$s. You are running "AutomateWoo" %3$s.', 'wc-price-based-country-pro' ), '<strong>', '</strong>', $plugin_version, $min_version );
			add_action( 'admin_notices', array( __CLASS__, 'min_version_notice' ) );
			return false;
		}

		return true;
	}

	/**
	 * Display admin minimun version required
	 */
	public static function min_version_notice() {
		echo '<div id="message" class="error"><p>' . wp_kses_post( self::$notice ) . '</p></div>';
	}
}

if ( WCPBC_Automatewoo::check_environment() ) {
	WCPBC_Automatewoo::init();
}
