;( function( $ ) {

	if ( typeof wcpbc_price_preview_params === 'undefined' ) {
		return false;
	}

	/**
	 * Price preview.
	 */
	 $.fn.wcpbc_price_preview = function() {

		function getPlaceholder($el) {
			let value = $el.attr('placeholder');
			if ( 'undefined' == typeof value ) {
				value = '';
			}
			return value;
		}

		function getCurrencyCode($me) {
			const $currencySel = $( $me.data('preview-currency') ).find('option:selected');
			let currencyCode   = '';

			if ( $currencySel.length ) {
				currencyCode = $currencySel.val();
			}
			return currencyCode;
		}

		function getCurrencySymbol($me) {
			const $currencySel = $( $me.data('preview-currency') ).find('option:selected');
			let currencySymbol = '';

			if ( $currencySel.length ) {
				currencySymbol = $currencySel.text();

				const pos = currencySymbol.lastIndexOf('(');
				if (pos > -1) {
					currencySymbol = currencySymbol.substring(pos+1).replace(')', '');
				}
			}
			return currencySymbol;
		}

		function getCurrencySymbolAlt( $me ) {
			const code = getCurrencyCode( $me );
			let symbolAlt = '';
			if ( typeof wcpbc_price_preview_params.alt_currency_symbols[code] !== 'undefined' ) {
				symbolAlt = wcpbc_price_preview_params.alt_currency_symbols[code];
			} else {
				symbolAlt = getCurrencySymbol($me);
			}
			return symbolAlt;
		}

		function getTrimZeros($me) {
			let value = false;
			const $that = $( $me.data('preview-trim-zeros') );
			if ( $that.length > 0 ) {
				value = $that.val() == 'yes';
			}
			return value;
		}

		function getNumDecimals($me) {

			if ( getTrimZeros($me)) {
				return 0;
			}

			let numDecimals = 0;
			const $numDecimalsInput = $( $me.data('preview-num-decimals') );

			if ( $numDecimalsInput.length ) {
				numDecimals = $numDecimalsInput.val();
				if ( numDecimals.length<1 ) {
					numDecimals = getPlaceholder($numDecimalsInput);
				}
			}
			return parseInt(numDecimals);
		}

		function getDecimalPoint($me) {
			let decimalPoint = '';
			const $decimalPointInput = $( $me.data('preview-decimal-sep') );
			if ( $decimalPointInput.length ) {
				decimalPoint = $decimalPointInput.val();
				if ( decimalPoint.length<1 ) {
					decimalPoint = getPlaceholder($decimalPointInput);
				}
			}
			return decimalPoint;
		}

		function getPrice($me) {
			let price = '99';
			const numDecimals = getNumDecimals($me);
			const decimalSep  = (numDecimals>0) ? getDecimalPoint($me) : '';
			price += decimalSep + '0'.repeat(numDecimals);
			return price;
		}

		function isValidValue( previewText ) {
			let regex = /\[price\]|\[code\]|\[symbol\]|\[symbol\-alt\]/g
			let validation = previewText.replace(regex, '');
			return validation.trim().length<1;
		}

		function errorTip( $me ) {
			var offset = $me.position();

			if ( $me.parent().find( '.wcpbc_error_tip' ).length === 0 ) {
				$me.after(
					`<div class="wcpbc_error_tip">${wcpbc_price_preview_params.i18n_invalid_value_error}</div>`
				);

				$me.parent().find( '.wcpbc_error_tip' )
					.css(
						'left',
						offset.left +
							$me.width() -
							$me.width() / 2 -
							$( '.wcpbc_error_tip' ).width() / 2
					)
					.css( 'top', offset.top + $me.height() )
					.fadeIn( '100' );
			}
		}

		function removeErrorTip( $me ) {
			if ( $me.parent().find( '.wcpbc_error_tip' ).length > 0 ) {
				$me.parent().find( '.wcpbc_error_tip' ).fadeOut( '100', function () {
					$( this ).remove();
				} );
			}
		}

		function pricePreview( $me ) {

			const $preview = $( $me.data('price-preview') );
			let previewText = $me.val();

			if ( ! isValidValue(previewText) ) {
				errorTip($me);
				previewText = '';
			}

			if ( previewText.length<1 ) {
				previewText = getPlaceholder($me);
			}

			if ( previewText.length<1 ) {
				previewText = wcpbc_price_preview_params.default_format;
			}

			if ( previewText.indexOf('[price]') < 0 ) {
				previewText = previewText + '[price]';
			}

			previewText = previewText
				.replace('[price]', getPrice($me))
				.replace('[code]', getCurrencyCode($me))
				.replace('[symbol]', getCurrencySymbol($me))
				.replace('[symbol-alt]', getCurrencySymbolAlt($me))
				.replace(' ', '&nbsp;');

			$preview.html(previewText);
		}

		$(this).on('change', function(){
			pricePreview( $(this) );
		});

		$(this).on('input', function(){
			removeErrorTip( $(this) );
		});

		// Show/Hide the element.
		this.each(function() {

			const $preview = $( $(this).data('price-preview') );
			if ( $preview.length < 1 ) {
				return;
			}
			const $that = $(this);

			['preview-currency', 'preview-num-decimals', 'preview-decimal-sep', 'preview-trim-zeros'].forEach(function(target){
				let $el = $( $that.data(target) );
				if ( $el.length > 0 ){
					$el.on('change', function(){
						$that.triggerHandler('change');
					});
				}
			});

			pricePreview($that);
		});
	}

	function addStyles() {
		const css = `.wcpbc_error_tip {color: #fff;font-size: 0.8em;text-align: center;border-radius: 3px;padding: 0.618em 1em;box-shadow: 0 1px 3px rgba(0, 0, 0, 0.2);max-width: 20em;line-height: 1.8em;position: absolute;white-space: normal;background: #d82223;margin: 1.5em 1px 0 -1em;z-index: 9999999;}.wcpbc_error_tip::after {content: "";display: block;border: 8px solid #d82223;border-right-color: transparent;border-left-color: transparent;border-top-color: transparent;position: absolute;top: -3px;left: 50%;margin: -1em 0 0 -3px;}`,
			style = document.createElement('style');
		style.innerText =css;
		document.head.appendChild(style);
	}

	$(document).ready(function(){
		addStyles();
		$('[data-price-preview]').wcpbc_price_preview();
	});

})( jQuery );