<?php
/**
 * Backward compatibility functions.
 *
 * @since 3.6.0
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;

/**
 * WCPBC_Backward_Compatibility class.
 */
class WCPBC_Backward_Compatibility {

	/**
	 * Returns the wrapper product types.
	 *
	 * @return array
	 */
	public static function wrapper_product_types() {
		return function_exists( 'wcpbc_wrapper_product_types' ) ? wcpbc_wrapper_product_types() : WCPBC_Product_Sync::get_parent_product_types();
	}

	/**
	 * Sync the price of the parent products.
	 *
	 * @param array $args Array of arguments.
	 * @param int   $limit Max number or records to be processed.
	 */
	public static function product_price_sync( $args = array(), $limit = 100 ) {
		if ( class_exists( 'WCPBC_Product_Meta_Data' ) ) {
			return;
		}

		WCPBC_Product_Sync::parent_product_price_sync( $args, $limit );
	}
}

