( function ( wp, data ) {
    const el = wp.element.createElement,
	components = wp.components,
	blockEditor = wp.blockEditor,
	__ = wp.i18n.__;

	const icon = function() {
		//https://icon-sets.iconify.design/?query=world
		return el(
			wp.primitives.SVG,
			{
				xmlns: 'http://www.w3.org/2000/svg',
				viewBox: '0 0 24 24',
			},
			el(
				'g', {
					'fill': "none",
					'stroke': "currentColor",
					'strokeLinecap': "round",
					'strokeLinejoin': "round",
					'strokeWidth': "2"
				},
				el(
					'path', {
						d: "M20.876 10.51a9 9 0 1 0-7.839 10.43M3.6 9h16.8M3.6 15h9.9"
					}
				),
				el(
					'path', {
						d: "M11.5 3a17 17 0 0 0 0 18m1-18a17 17 0 0 1 2.578 9.02M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3H17m2 0v1m0-8v1"
					}
				)
			)
		);
	};

	// Decode currency symbols.
	const txtDecoder = document.createElement('textarea');
	data = data.map((currency) => {
		txtDecoder.innerHTML = currency.symbol;
		currency.symbol = txtDecoder.value;
		return currency;
	} );
	txtDecoder.remove();

	wp.blocks.registerBlockType( 'woocommerce-product-price-based-on-countries/currency-switcher', {
		icon: icon,
		edit: function ( {attributes, setAttributes} ) {

			function settingsControls() {
				return [
					el(
						components.ToggleControl, {
						label: __( 'Display flags in supported devices', 'wc-price-based-country-pro' ),
						checked: attributes.flag,
						onChange: (value) => { setAttributes({ flag: value }); }
					}),
					el(
						components.TextControl, {
						label: __( 'Display', 'wc-price-based-country-pro' ),
						help:  __( 'Supports the following placeholders: [name] = currency name, [code] = currency code and [symbol] = currency symbol', 'wc-price-based-country-pro' ),
						value: attributes.currency_display_style,
						onChange: (value) => { setAttributes({ currency_display_style: value }); }
					})
				];
			};

			function dropdownOption(currency)  {
				const icon = attributes.flag ? currency.emoji_flag : '',
					text = attributes.currency_display_style.replaceAll(
						/(\[code\])|(\[symbol\])|(\[name\])/g,
						function($matched) {
							$key = $matched.replaceAll(/(\[)|(\])/g, '');
							return currency[$key];
						}
					);
				return el(
					'option', {
						className: 'wp-exclude-emoji'
					},
					`${icon} ${text}`
				);
			};

			return el(
                'div',
                blockEditor.useBlockProps(),
				el(
					'select', {
						className: 'wp-exclude-emoji'
					},
					...data.map(dropdownOption)
				),
				el(
					blockEditor.InspectorControls,
					{},
					el(
						components.PanelBody,
						{
							title: 'Settings',
							initialOpen: true
						},
						...settingsControls()
					)
				)
			);
		}
	});
} )(
	wp,
	wc_price_based_country_currency_switcher_block_data
);