<?php
/**
 * Currency Switcher block.
 *
 * @since 3.6.0
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'WCPBC_Base_Block' ) ) {
	return;
}

/**
 * WCPBC_Currency_Switcher_Block Class
 */
class WCPBC_Currency_Switcher_Block extends WCPBC_Base_Block {

	/**
	 * Constructor
	 */
	public function __construct() {
		parent::__construct(
			[
				'id'          => 'currency-switcher',
				'title'       => __( 'Currency Switcher', 'wc-price-based-country-pro' ),
				'description' => __( 'Display a currency switcher using a dropdown. It groups the countries by currency. When the user changes the currency, he also changes his country.', 'wc-price-based-country-pro' ),
				'keywords'    => [ 'currency' ],
				'attributes'  => [
					'flag'                   => [
						'type'    => 'boolean',
						'default' => false,
					],
					'currency_display_style' => [
						'type'    => 'string',
						'default' => '[name] ([symbol])',
					],
				],
			]
		);
	}

	/**
	 * Returns the plugin file
	 *
	 * @return string
	 */
	public function get_plugin_file() {
		return WCPBC_PRO_PLUGIN_FILE;
	}

	/**
	 * Returns the textdomain
	 *
	 * @return string
	 */
	public function get_textdomain() {
		return 'wc-price-based-country-pro';
	}

	/**
	 * Returns the Block editor script data
	 *
	 * @return array
	 */
	public function get_editor_script_data() {
		$data = WCPBC_Widget_Currency_Switcher::get_data();
		return $data['data'];
	}

	/**
	 * Render the block.
	 *
	 * @param array  $attributes Block attributes.
	 * @param string $content    Block content.
	 * @return string Rendered block type output.
	 */
	public function render( $attributes, $content ) {
		$attributes['title'] = '';
		ob_start();
		the_widget(
			'WCPBC_Widget_Currency_Switcher',
			$attributes,
			array(
				'before_widget' => '',
				'after_widget'  => '',
			)
		);

		return ob_get_clean();
	}
}
