<?php
/**
 * Extend the Action_Subscription_Add_Product action to add the product with the correct prices.
 *
 * @since 3.2.0
 * @package WCPBC
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * WCPBC_Automatewoo Class
 */
class WCPBC_Automatewoo_Action_Subscription_Add_Product extends \AutomateWoo\Action_Subscription_Add_Product {

	use WCPBC_Automatewoo_Action_Trait;

	/**
	 * Update the product with the prices of the pricing zone.
	 *
	 * @param \WC_Product         $product Product.
	 * @param \WCPBC_Pricing_Zone $zone Pricing zone.
	 */
	protected function update_product_price( $product, $zone ) {
		foreach ( array( '_price', '_regular_price', '_sale_price' ) as $meta_key ) {

			$getter = 'get' . $meta_key;
			$setter = 'set' . $meta_key;
			$value  = $product->{$getter}( 'edit' );

			// Force change on the prices properties updating it with a ridiculous value.
			$product->{$setter}( -9999 );

			// Set the real price.
			$product->{$setter}(
				$zone->get_price_prop(
					$product,
					$value,
					$meta_key
				)
			);
		}
		if ( is_callable( [ 'WC_Subscriptions_Product', 'is_subscription' ] ) && WC_Subscriptions_Product::is_subscription( $product ) ) {
			$value = $product->get_meta(
				'_subscription_sign_up_fee',
				true,
				'view'
			);

			$product->update_meta_data(
				'_subscription_sign_up_fee',
				$zone->get_price_prop(
					$product,
					$value,
					'_subscription_sign_up_fee'
				)
			);
		}
	}

	/**
	 * Add a given product as a line item to a given subscription.
	 *
	 * @param \WC_Product      $product Product to add to the subscription.
	 * @param \WC_Subscription $subscription Instance of subscription to add the product to.
	 *
	 * @return bool True if the subscription was edited, false if no change was made.
	 */
	protected function edit_subscription( $product, $subscription ) {

		$zone = WCPBC_Pricing_Zones::get_zone_from_order( $subscription );

		if ( $zone ) {
			$this->update_product_price( $product, $zone );
			$this->update_line_cost( $zone );
		}

		return parent::edit_subscription( $product, $subscription );
	}
}
