<?php
/**
 * Extend the Variable_Cart_Total variable to display the correct currency.
 *
 * @since 3.4.6
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;

/**
 * Variable {{ cart.total }} class.
 *
 * WCPBC_Automatewoo_Variable_Cart_Total
 */
class WCPBC_Automatewoo_Variable_Cart_Total extends \AutomateWoo\Variable_Cart_Total {

	/**
	 * Get Value Method
	 *
	 * @param Cart  $cart Cart instance.
	 * @param array $parameters Parameters.
	 *
	 * @return string
	 */
	public function get_value( $cart, $parameters ) {
		return parent::format_amount( $cart->get_total(), $parameters, $cart->get_currency() );
	}
}

