<?php
/**
 * WP All Import pricing zone options.
 *
 * @package WCPBC
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="wcpbc-wpallimport-col-2 switcher-target-<?php echo esc_attr( sanitize_title( self::get_option_name( '_price_method', $zone ) ) . '_exchange_rate' ); ?>">
	<div class="input">
		<p class="form-field wcpbc-wpallimport-text-field">
			<label for="<?php echo esc_attr( self::get_option_name( '_regular_price', $zone ) ); ?>">
				<?php esc_html_e( 'Regular price', 'wc-price-based-country-pro' ); ?>
			</label>
			<input type="text" name="<?php echo esc_attr( self::get_option_name( '_regular_price', $zone ) ); ?>" id="<?php echo esc_attr( sanitize_title( self::get_option_name( '_regular_price', $zone ) ) ); ?>" value="<?php echo esc_attr( self::get_post_value( $post, '_regular_price', $zone ) ); ?>"/>
		</p>
	</div>
	<div class="input">
		<p class="form-field wcpbc-wpallimport-text-field">
			<label for="<?php echo esc_attr( self::get_option_name( '_sale_price', $zone ) ); ?>">
				<?php esc_html_e( 'Sale price', 'wc-price-based-country-pro' ); ?>
			</label>
			<input type="text" name="<?php echo esc_attr( self::get_option_name( '_sale_price', $zone ) ); ?>" id="<?php echo esc_attr( sanitize_title( self::get_option_name( '_sale_price', $zone ) ) ); ?>" value="<?php echo esc_attr( self::get_post_value( $post, '_sale_price', $zone ) ); ?>"/>
		</p>
	</div>
</div>
