# PublishPress Revisions

Maintain published content with teamwork and precision using the Revisions model to submit, moderate and schedule changes.

## Description

WordPress Revisions are a powerful way to track where your site has been. But what about where it's going?

To moderate or schedule changes to published posts, just install PublishPress Revisions and let the teamwork begin.  There is no need to learn or configure complex new screens. Users gain new abilities through the familiar UI of the Edit Posts screen and Gutenberg or Classic Editor. 

### New Editorial Capabilities, Smoothly Integrated
* "Contributors" can submit revisions to their own published posts.
* "Revisors" can submit revisions to posts and pages published by others.
* "Authors", "Editors" and "Administrators" can approve revisions or schedule their own revisions.
* To schedule changes to a published post, just set the desired future date before hitting Update.

### Features
* Schedule or request changes to published posts and pages using the Gutenberg (or Classic) Editor
* Revision fields include Content, Title, Excerpt, Categories, Tags, Custom Taxonomy Terms, Page Parent or Page Template
* Display changes using the familiar Compare Revisions interface
* Front-end preview display of Pending / Scheduled Revisions with Compare, Approve, and Edit buttons.
* Make further changes to Pending Revisions and Scheduled Revisions with Gutenberg or Classic Editor
* New WordPress role, "Revisor" is a moderated Editor.
* Works with site-wide WordPress Roles, or in conjunction with <a href="https://publishpress.com/presspermit/">PressPermit Pro</a> for page-specific or category-specific permissions.

### Additional Features in the Pro Version
* Advanced Custom Fields integration
* BeaverBuilder integration
* The Events Calendar compatibility
* WooCommerce compatibility
* WPML integration

## Documentation

https://publishpress.com/documentation/revisionary-start


## How to report bugs or send suggestions

Feel free to email us via [help@publishpress.com](mailto:help@publishpress.com). We would love to hear you, and will work hard to help you.

### Guidelines

* Write a clear summary
* Write precise steps to reproduce

## How to contribute with code

* Clone the repository
* Create a new branch
* Implement and commit the code
* Create a Pull Request targetting the "development" branch adding details about your fix

We will review and contact you as soon as possible.

## License

License: [GPLv3 or later](http://www.gnu.org/licenses/gpl-3.0.html)
