<?php
if (!empty($_SERVER['SCRIPT_FILENAME']) && basename(__FILE__) == basename(esc_url_raw($_SERVER['SCRIPT_FILENAME'])) )
	die( 'This page cannot be called directly.' );

/**
 * @package     PublishPress\Revisions\RevisionaryWooCommerce
 * @author      PublishPress <help@publishpress.com>
 * @copyright   Copyright (c) 2022 PublishPress. All rights reserved.
 * @license     GPLv2 or later
 * @since       1.0.0
 */
class RevisionaryWooCommerce
{
    function __construct() {
        add_action('revisionary_new_revision', [$this, 'actNewRevisionCopyVariations'], 10, 2);

        add_action('revision_applied', [$this, 'actApplyRevisionCopyVariations'], 10, 2);

        add_action('delete_post', [$this, 'actDeletePost']);
    }

    function actNewRevisionCopyVariations($revision_id, $revision_status) {
        global $wpdb;

        $revision = get_post($revision_id);

        if (!$revision || ('product' != $revision->post_type)) {
            return;
        }

        if (!$published_post = get_post(rvy_post_id($revision_id))) {
            return;
        }

        RevisionaryPro::instance()->copySubposts($published_post->ID, $revision_id, 'product_variation');
    }

    function actApplyRevisionCopyVariations($published_id, $revision) {
        if (!$revision || ('product' != $revision->post_type)) {
            return;
        }

        RevisionaryPro::instance()->deleteSubposts($published_id, 'product_variation');

        RevisionaryPro::instance()->copySubposts($revision->ID, $published_id, 'product_variation');
    }

    function actDeletePost($post_id) {
        if (rvy_in_revision_workflow($post_id)) {
            RevisionaryPro::instance()->deleteSubposts($post_id, 'product_variation');
        }
    }
}
