<?php
/**
 * Setting options for new skin template
 *
 * @version             1.5.0
 * @package           TInvWishlist\Template
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$font_family = apply_filters( 'tinwl_prepare_fonts', array(
	'inherit'                                                            => __( 'Use Default Font', 'ti-woocommerce-wishlist-premium' ),
	'Georgia, serif'                                                     => __( 'Georgia', 'ti-woocommerce-wishlist-premium' ),
	"'Times New Roman', Times, serif"                                    => __( 'Times New Roman, Times', 'ti-woocommerce-wishlist-premium' ),
	'Arial, Helvetica, sans-serif'                                       => __( 'Arial, Helvetica', 'ti-woocommerce-wishlist-premium' ),
	"'Courier New', Courier, monospace"                                  => __( 'Courier New, Courier', 'ti-woocommerce-wishlist-premium' ),
	"Georgia, 'Times New Roman', Times, serif"                           => __( 'Georgia, Times New Roman, Times', 'ti-woocommerce-wishlist-premium' ),
	'Verdana, Arial, Helvetica, sans-serif'                              => __( 'Verdana, Arial, Helvetica', 'ti-woocommerce-wishlist-premium' ),
	'Geneva, Arial, Helvetica, sans-serif'                               => __( 'Geneva, Arial, Helvetica', 'ti-woocommerce-wishlist-premium' ),
	"'Source Sans Pro', 'Open Sans', sans-serif"                         => __( 'Source Sans Pro, Open Sans', 'ti-woocommerce-wishlist-premium' ),
	"'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif"             => __( 'Helvetica Neue, Helvetica, Roboto, Arial', 'ti-woocommerce-wishlist-premium' ),
	'Arial, sans-serif'                                                  => __( 'Arial', 'ti-woocommerce-wishlist-premium' ),
	"'Lucida Grande', Verdana, Arial, 'Bitstream Vera Sans', sans-serif" => __( 'Lucida Grande, Verdana, Arial, Bitstream Vera Sans', 'ti-woocommerce-wishlist-premium' ),
) );

$fields = array(
	array(
		'type'       => 'group',
		'title'      => __( 'text', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-header h2',
		'element'  => 'color',
		'text'     => __( 'Title Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist .tinv-header h2',
		'element'  => 'font-size',
		'text'     => __( 'Title Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist',
		'element'  => 'color',
		'text'     => __( 'Content Text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'select',
		'selector' => '.tinv-wishlist,.tinv-wishlist a,.tinv-wishlist button,.tinv-wishlist input,.tinv-wishlist select,.tinv-wishlist textarea,.tinv-wishlist button,.tinv-wishlist input[type="button"],.tinv-wishlist input[type="reset"],.tinv-wishlist input[type="submit"]',
		'element'  => 'font-family',
		'text'     => __( 'Font', 'ti-woocommerce-wishlist-premium' ),
		'options'  => $font_family,
		'validate' => array( 'filter' => FILTER_DEFAULT ),
	),
	array(
		'type'       => 'group',
		'title'      => __( 'links', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist a:not(.tinvwl-button),.tinv-wishlist td.wishlist-name a,.tinv-wishlist td.wishlist-name .tinvwl-name-to-rename a,.tinv-wishlist td.product-name a',
		'element'  => 'color',
		'text'     => __( 'Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist a:not(.tinvwl-button):hover,.tinv-wishlist a:not(.tinvwl-button):active,.tinv-wishlist a:not(.tinvwl-button):focus',
		'element'  => 'color',
		'text'     => __( 'Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'select',
		'selector' => '.tinv-wishlist a:not(.tinvwl-button)',
		'element'  => 'border-bottom',
		'text'     => __( 'Underline', 'ti-woocommerce-wishlist-premium' ),
		'options'  => array(
			''                => __( 'Yes', 'ti-woocommerce-wishlist-premium' ),
			'none !important' => __( 'No', 'ti-woocommerce-wishlist-premium' ),
		),
	),
	array(
		'type'       => 'group',
		'title'      => __( 'fields', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist input[type="text"],.tinv-wishlist input[type="email"],.tinv-wishlist input[type="url"],.tinv-wishlist input[type="password"],.tinv-wishlist input[type="search"],.tinv-wishlist input[type="tel"],.tinv-wishlist input[type="number"],.tinv-wishlist select',
		'element'  => 'background-color',
		'text'     => __( 'Rounded Fields Background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist input[type="text"]:focus,.tinv-wishlist input[type="email"]:focus,.tinv-wishlist input[type="url"]:focus,.tinv-wishlist input[type="password"]:focus,.tinv-wishlist input[type="search"]:focus,.tinv-wishlist input[type="tel"]:focus,.tinv-wishlist input[type="number"]:focus,.tinv-wishlist select:focus,.tinv-wishlist input[type="text"]:hover,.tinv-wishlist input[type="email"]:hover,.tinv-wishlist input[type="url"]:hover,.tinv-wishlist input[type="password"]:hover,.tinv-wishlist input[type="search"]:hover,.tinv-wishlist input[type="tel"]:hover,.tinv-wishlist input[type="number"]:hover,.tinv-wishlist select:hover',
		'element'  => 'background-color',
		'text'     => __( 'Rounded Fields Hover Background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'       => 'color_important',
		'selector'   => '.tinv-wishlist input[type="text"]:focus,.tinv-wishlist input[type="email"]:focus,.tinv-wishlist input[type="url"]:focus,.tinv-wishlist input[type="password"]:focus,.tinv-wishlist input[type="search"]:focus,.tinv-wishlist input[type="tel"]:focus,.tinv-wishlist input[type="number"]:focus,.tinv-wishlist select:focus,.tinv-wishlist input[type="text"]:hover,.tinv-wishlist input[type="email"]:hover,.tinv-wishlist input[type="url"]:hover,.tinv-wishlist input[type="password"]:hover,.tinv-wishlist input[type="search"]:hover,.tinv-wishlist input[type="tel"]:hover,.tinv-wishlist input[type="number"]:hover,.tinv-wishlist select:hover',
		'element'    => 'box-shadow',
		'subelement' => array( '-webkit-box-shadow', '-moz-box-shadow' ),
		'text'       => __( 'Rounded Border Color', 'ti-woocommerce-wishlist-premium' ),
		'format'     => 'inset 0 0 0 2px {0}',
		'extra'      => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist input[type="text"],.tinv-wishlist input[type="email"],.tinv-wishlist input[type="url"],.tinv-wishlist input[type="password"],.tinv-wishlist input[type="search"],.tinv-wishlist input[type="tel"],.tinv-wishlist input[type="number"],.tinv-wishlist select',
		'element'  => 'border-radius',
		'text'     => __( 'Rounded Fields Border Radius', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist input[type="text"],.tinv-wishlist input[type="email"],.tinv-wishlist input[type="url"],.tinv-wishlist input[type="password"],.tinv-wishlist input[type="search"],.tinv-wishlist input[type="tel"],.tinv-wishlist input[type="number"],.tinv-wishlist select',
		'element'  => 'color',
		'text'     => __( 'Rounded Fields Text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-wrapped-block input[type="text"],.tinv-wishlist .tinv-wrapped-block input[type="password"],.tinv-wishlist.widget input[type="search"],.tinv-wishlist .tinv-wrapped-block input[type="search"],.tinv-wishlist textarea,.tinv-wishlist .tinv-modal .tinv-modal-inner input,.tinv-wishlist .tinv-modal .tinv-modal-inner select,.tinv-wishlist .product-quantity input[type="number"].qty,.tinv-wishlist .product-quantity input[type="text"].qty',
		'element'  => 'color',
		'text'     => __( 'Underlined Fields Text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-wrapped-block input[type="text"],.tinv-wishlist .tinv-wrapped-block input[type="password"],.tinv-wishlist.widget input[type="search"],.tinv-wishlist .tinv-wrapped-block input[type="search"],.tinv-wishlist textarea,.tinv-wishlist .tinv-modal .tinv-modal-inner input,.tinv-wishlist .tinv-modal .tinv-modal-inner select,.tinv-wishlist .product-quantity input[type="number"].qty,.tinv-wishlist .product-quantity input[type="text"].qty',
		'element'  => 'border-color',
		'text'     => __( 'Underlined Border Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-wrapped-block input[type="text"]:focus,.tinv-wishlist .tinv-wrapped-block input[type="password"]:focus,.tinv-wishlist.widget input[type="search"]:focus,.tinv-wishlist .tinv-wrapped-block input[type="search"]:focus,.tinv-wishlist textarea:focus,.tinv-wishlist .tinv-modal .tinv-modal-inner input:focus,.tinv-wishlist .tinv-modal .tinv-modal-inner select:focus,.tinv-wishlist .product-quantity input[type="number"].qty:focus,.tinv-wishlist .product-quantity input[type="text"].qty:focus,.tinv-wishlist .tinv-wrapped-block input[type="text"]:hover,.tinv-wishlist .tinv-wrapped-block input[type="password"]:hover,.tinv-wishlist.widget input[type="search"]:hover,.tinv-wishlist .tinv-wrapped-block input[type="search"]:hover,.tinv-wishlist textarea:hover,.tinv-wishlist .tinv-modal .tinv-modal-inner input:hover,.tinv-wishlist .tinv-modal .tinv-modal-inner select:hover,.tinv-wishlist .product-quantity input[type="number"].qty:hover,.tinv-wishlist .product-quantity input[type="text"].qty:hover',
		'element'  => 'border-color',
		'text'     => __( 'Underline Border Color on Hover', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'select',
		'selector' => '.tinv-wishlist input[type="text"],.tinv-wishlist input[type="email"],.tinv-wishlist input[type="url"],.tinv-wishlist input[type="password"],.tinv-wishlist input[type="search"],.tinv-wishlist input[type="tel"],.tinv-wishlist input[type="number"],.tinv-wishlist textarea,.tinv-wishlist select,.tinv-wishlist .product-quantity input[type="text"].qty',
		'element'  => 'font-family',
		'text'     => __( 'Font', 'ti-woocommerce-wishlist-premium' ),
		'options'  => $font_family,
		'validate' => array( 'filter' => FILTER_DEFAULT ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist input[type="text"],.tinv-wishlist input[type="email"],.tinv-wishlist input[type="url"],.tinv-wishlist input[type="password"],.tinv-wishlist input[type="search"],.tinv-wishlist input[type="tel"],.tinv-wishlist input[type="number"],.tinv-wishlist textarea,.tinv-wishlist select,.tinv-wishlist .product-quantity input[type="text"].qty',
		'element'  => 'font-size',
		'text'     => __( 'Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'       => 'group',
		'title'      => __( 'add to wishlist catalog button', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinvwl_add_to_wishlist_button:before,.woocommerce ul.products li a.tinvwl_add_to_wishlist_button:before,.woocommerce ul.products li.product a.tinvwl_add_to_wishlist_button:before',
		'element'  => 'color',
		'text'     => __( 'Icon Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinvwl_add_to_wishlist_button:hover:before,.woocommerce ul.products li a.tinvwl_add_to_wishlist_button:hover:before,.woocommerce ul.products li.product a.tinvwl_add_to_wishlist_button:hover:before,.tinv-wishlist .tinvwl_add_to_wishlist_button.tinvwl-product-in-list:before,.woocommerce ul.products li a.tinvwl_add_to_wishlist_button.tinvwl-product-in-list:before,.woocommerce ul.products li.product a.tinvwl_add_to_wishlist_button.tinvwl-product-in-list:before',
		'element'  => 'color',
		'text'     => __( 'Icon Hover/Active Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce ul.products li .tinvwl_add_to_wishlist_button',
		'element'  => 'background-color',
		'text'     => __( 'Background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce ul.products a.tinvwl_add_to_wishlist_button.tinvwl-product-in-list,.woocommerce ul.products a.tinvwl_add_to_wishlist_button:hover,.woocommerce ul.products a.tinvwl_add_to_wishlist_button:focus,.woocommerce ul.products a.tinvwl_add_to_wishlist_button:active,.woocommerce ul.products li .tinvwl_add_to_wishlist_button:hover,.woocommerce ul.products li .tinvwl_add_to_wishlist_button:active,.woocommerce ul.products li .tinvwl_add_to_wishlist_button:focus',
		'element'  => 'background-color',
		'text'     => __( 'Background Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'       => 'color_important',
		'selector'   => '.woocommerce ul.products li .tinvwl_add_to_wishlist_button',
		'element'    => 'box-shadow',
		'subelement' => array( '-webkit-box-shadow', '-moz-box-shadow' ),
		'text'       => __( 'Border Color', 'ti-woocommerce-wishlist-premium' ),
		'format'     => 'inset 0 0 0 3px {0}',
		'extra'      => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'       => 'color_important',
		'selector'   => '.woocommerce ul.products a.tinvwl_add_to_wishlist_button.tinvwl-product-in-list,.woocommerce ul.products a.tinvwl_add_to_wishlist_button:hover,.woocommerce ul.products a.tinvwl_add_to_wishlist_button:focus,.woocommerce ul.products a.tinvwl_add_to_wishlist_button:active,.woocommerce ul.products li .tinvwl_add_to_wishlist_button:hover,.woocommerce ul.products li .tinvwl_add_to_wishlist_button:active,.woocommerce ul.products li .tinvwl_add_to_wishlist_button:focus',
		'element'    => 'box-shadow',
		'subelement' => array( '-webkit-box-shadow', '-moz-box-shadow' ),
		'text'       => __( 'Border Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'format'     => 'inset 0 0 0 3px {0}',
		'extra'      => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),

	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce ul.products a.tinvwl_add_to_wishlist_button,.woocommerce ul.products li .tinvwl_add_to_wishlist_button',
		'element'  => 'color',
		'text'     => __( 'Text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce ul.products a.tinvwl_add_to_wishlist_button.tinvwl-product-in-list,.woocommerce ul.products a.tinvwl_add_to_wishlist_button:hover,.woocommerce ul.products a.tinvwl_add_to_wishlist_button:focus,.woocommerce ul.products a.tinvwl_add_to_wishlist_button:active,.woocommerce ul.products li.product .tinvwl_add_to_wishlist_button:hover,.woocommerce ul.products li.product .tinvwl_add_to_wishlist_button:active,.woocommerce ul.products li.product .tinvwl_add_to_wishlist_button:focus',
		'element'  => 'color',
		'text'     => __( 'Text Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'select',
		'selector' => '.woocommerce ul.products a.tinvwl_add_to_wishlist_button,.woocommerce ul.products li .tinvwl_add_to_wishlist_button',
		'element'  => 'font-family',
		'text'     => __( 'Font', 'ti-woocommerce-wishlist-premium' ),
		'options'  => $font_family,
		'validate' => array( 'filter' => FILTER_DEFAULT ),
	),
	array(
		'type'     => 'text',
		'selector' => '.woocommerce ul.products a.tinvwl_add_to_wishlist_button,.woocommerce ul.products li .tinvwl_add_to_wishlist_button',
		'element'  => 'font-size',
		'text'     => __( 'Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'text',
		'selector' => '.woocommerce ul.products li .tinvwl_add_to_wishlist_button',
		'element'  => 'border-radius',
		'text'     => __( 'Border Radius', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'       => 'group',
		'title'      => __( 'add to wishlist product page button', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button',
		'element'  => 'background-color',
		'text'     => __( 'Background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button.tinvwl-product-in-list,.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button:hover,.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button:active,.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button:focus',
		'element'  => 'background-color',
		'text'     => __( 'Background Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'       => 'color_important',
		'selector'   => '.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button',
		'element'    => 'box-shadow',
		'subelement' => array( '-webkit-box-shadow', '-moz-box-shadow' ),
		'text'       => __( 'Border Color', 'ti-woocommerce-wishlist-premium' ),
		'format'     => 'inset 0 0 0 3px {0}',
		'extra'      => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'       => 'color_important',
		'selector'   => '.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button.tinvwl-product-in-list,.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button:hover,.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button:active,.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button:focus',
		'element'    => 'box-shadow',
		'subelement' => array( '-webkit-box-shadow', '-moz-box-shadow' ),
		'text'       => __( 'Border Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'format'     => 'inset 0 0 0 3px {0}',
		'extra'      => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),

	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button',
		'element'  => 'color',
		'text'     => __( 'Text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button.tinvwl-product-in-list,.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button:hover,.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button:active,.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button:focus',
		'element'  => 'color',
		'text'     => __( 'Text Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce div.product form.cart a.tinvwl_add_to_wishlist_button:before',
		'element'  => 'color',
		'text'     => __( 'Icon Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce div.product form.cart a.tinvwl_add_to_wishlist_button:hover:before,.woocommerce div.product form.cart a.tinvwl_add_to_wishlist_button.tinvwl-product-in-list:before',
		'element'  => 'color',
		'text'     => __( 'Icon Hover/Active Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'select',
		'selector' => '.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button',
		'element'  => 'font-family',
		'text'     => __( 'Font', 'ti-woocommerce-wishlist-premium' ),
		'options'  => $font_family,
		'validate' => array( 'filter' => FILTER_DEFAULT ),
	),
	array(
		'type'     => 'text',
		'selector' => '.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button',
		'element'  => 'font-size',
		'text'     => __( 'Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'text',
		'selector' => '.woocommerce div.product form.cart .tinvwl_add_to_wishlist_button',
		'element'  => 'border-radius',
		'text'     => __( 'Border Radius', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'       => 'group',
		'title'      => __( 'accent buttons style', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist button,.tinv-wishlist input[type="button"],.tinv-wishlist input[type="reset"],.tinv-wishlist input[type="submit"]',
		'element'  => 'background-color',
		'text'     => __( 'Background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist button:hover,.tinv-wishlist button:focus,.tinv-wishlist input[type="button"]:hover,.tinv-wishlist input[type="button"]:focus,.tinv-wishlist input[type="reset"]:hover,.tinv-wishlist input[type="reset"]:focus,.tinv-wishlist input[type="submit"]:hover,.tinv-wishlist input[type="submit"]:focus',
		'element'  => 'background-color',
		'text'     => __( 'Background Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist button,.tinv-wishlist input[type="button"],.tinv-wishlist input[type="reset"],.tinv-wishlist input[type="submit"]',
		'element'  => 'color',
		'text'     => __( 'Text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist button:hover,.tinv-wishlist button:focus,.tinv-wishlist input[type="button"]:hover,.tinv-wishlist input[type="button"]:focus,.tinv-wishlist input[type="reset"]:hover,.tinv-wishlist input[type="reset"]:focus,.tinv-wishlist input[type="submit"]:hover,.tinv-wishlist input[type="submit"]:focus',
		'element'  => 'color',
		'text'     => __( 'Text Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'select',
		'selector' => '.tinv-wishlist button,.tinv-wishlist input[type="button"],.tinv-wishlist input[type="reset"],.tinv-wishlist input[type="submit"]',
		'element'  => 'font-family',
		'text'     => __( 'Font', 'ti-woocommerce-wishlist-premium' ),
		'options'  => $font_family,
		'validate' => array( 'filter' => FILTER_DEFAULT ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist button,.tinv-wishlist input[type="button"],.tinv-wishlist input[type="reset"],.tinv-wishlist input[type="submit"]',
		'element'  => 'font-size',
		'text'     => __( 'Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'text',
		'selector' => '.widget .tinvwl-search-submit:before',
		'element'  => 'font-size',
		'text'     => __( 'Search Widget Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist button,.tinv-wishlist input[type="button"],.tinv-wishlist input[type="reset"],.tinv-wishlist input[type="submit"]',
		'element'  => 'border-radius',
		'text'     => __( 'Border Radius', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'       => 'group',
		'title'      => __( 'normal buttons style', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinvwl-button,.wishlist_products_counter .widget_wishlist .tinvwl-button,.woocommerce.tinv-wishlist #respond input#submit,.woocommerce.tinv-wishlist a.tinvwl-button,.woocommerce.tinv-wishlist button.tinvwl-button,.woocommerce.tinv-wishlist input.tinvwl-button',
		'element'  => 'background-color',
		'text'     => __( 'Background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinvwl-button:hover,.wishlist_products_counter .widget_wishlist .tinvwl-button:hover,.woocommerce.tinv-wishlist #respond input#submit:hover,.woocommerce.tinv-wishlist a.tinvwl-button:hover,.woocommerce.tinv-wishlist button.tinvwl-button:hover,.woocommerce.tinv-wishlist input.tinvwl-button:hover',
		'element'  => 'background-color',
		'text'     => __( 'Background Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinvwl-button,.wishlist_products_counter .widget_wishlist .tinvwl-button,.woocommerce.tinv-wishlist #respond input#submit,.woocommerce.tinv-wishlist a.tinvwl-button,.woocommerce.tinv-wishlist button.tinvwl-button,.woocommerce.tinv-wishlist input.tinvwl-button',
		'element'  => 'color',
		'text'     => __( 'Text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinvwl-button:hover,.wishlist_products_counter .widget_wishlist .tinvwl-button:hover,.woocommerce.tinv-wishlist #respond input#submit:hover,.woocommerce.tinv-wishlist a.tinvwl-button:hover,.woocommerce.tinv-wishlist button.tinvwl-button:hover,.woocommerce.tinv-wishlist input.tinvwl-button:hover',
		'element'  => 'color',
		'text'     => __( 'Text Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'select',
		'selector' => '.tinv-wishlist .tinvwl-button,.wishlist_products_counter .widget_wishlist .tinvwl-button,.woocommerce.tinv-wishlist #respond input#submit,.woocommerce.tinv-wishlist a.tinvwl-button,.woocommerce.tinv-wishlist button.tinvwl-button,.woocommerce.tinv-wishlist input.tinvwl-button',
		'element'  => 'font-family',
		'text'     => __( 'Font', 'ti-woocommerce-wishlist-premium' ),
		'options'  => $font_family,
		'validate' => array( 'filter' => FILTER_DEFAULT ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist .tinvwl-button,.wishlist_products_counter .widget_wishlist .tinvwl-button,.woocommerce.tinv-wishlist #respond input#submit,.woocommerce.tinv-wishlist a.tinvwl-button,.woocommerce.tinv-wishlist button.tinvwl-button,.woocommerce.tinv-wishlist input.tinvwl-button',
		'element'  => 'font-size',
		'text'     => __( 'Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist .tinvwl-button,.wishlist_products_counter .widget_wishlist .tinvwl-button,.woocommerce.tinv-wishlist #respond input#submit,.woocommerce.tinv-wishlist a.tinvwl-button,.woocommerce.tinv-wishlist button.tinvwl-button,.woocommerce.tinv-wishlist input.tinvwl-button',
		'element'  => 'border-radius',
		'text'     => __( 'Border Radius', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'       => 'group',
		'title'      => __( 'Alternative button', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-login form input[name="login"],.woocommerce.tinv-wishlist #respond input#submit.alt,.woocommerce.tinv-wishlist a.tinvwl-button.alt,.woocommerce.tinv-wishlist button.tinvwl-button.alt,.woocommerce.tinv-wishlist input.tinvwl-button.alt',
		'element'  => 'background-color',
		'text'     => __( 'Background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-login form input[name="login"]:hover,.woocommerce.tinv-wishlist #respond input#submit.alt:hover,.woocommerce.tinv-wishlist a.tinvwl-button.alt:hover,.woocommerce.tinv-wishlist button.tinvwl-button.alt:hover,.woocommerce.tinv-wishlist input.tinvwl-button.alt:hover',
		'element'  => 'background-color',
		'text'     => __( 'Background Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-login form input[name="login"],.woocommerce.tinv-wishlist #respond input#submit.alt,.woocommerce.tinv-wishlist a.tinvwl-button.alt,.woocommerce.tinv-wishlist button.tinvwl-button.alt,.woocommerce.tinv-wishlist input.tinvwl-button.alt',
		'element'  => 'color',
		'text'     => __( 'Text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-login form input[name="login"]:hover,.woocommerce.tinv-wishlist #respond input#submit.alt:hover,.woocommerce.tinv-wishlist a.tinvwl-button.alt:hover,.woocommerce.tinv-wishlist button.tinvwl-button.alt:hover,.woocommerce.tinv-wishlist input.tinvwl-button.alt:hover',
		'element'  => 'color',
		'text'     => __( 'Text Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'select',
		'selector' => '.tinv-wishlist .tinv-login form input[name="login"],.woocommerce.tinv-wishlist #respond input#submit.alt,.woocommerce.tinv-wishlist a.tinvwl-button.alt,.woocommerce.tinv-wishlist button.tinvwl-button.alt,.woocommerce.tinv-wishlist input.tinvwl-button.alt',
		'element'  => 'font-family',
		'text'     => __( 'Font', 'ti-woocommerce-wishlist-premium' ),
		'options'  => $font_family,
		'validate' => array( 'filter' => FILTER_DEFAULT ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist .tinv-login form input[name="login"],.woocommerce.tinv-wishlist #respond input#submit.alt,.woocommerce.tinv-wishlist a.tinvwl-button.alt,.woocommerce.tinv-wishlist button.tinvwl-button.alt,.woocommerce.tinv-wishlist input.tinvwl-button.alt',
		'element'  => 'font-size',
		'text'     => __( 'Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist .tinv-login form input[name="login"],.woocommerce.tinv-wishlist #respond input#submit.alt,.woocommerce.tinv-wishlist a.tinvwl-button.alt,.woocommerce.tinv-wishlist button.tinvwl-button.alt,.woocommerce.tinv-wishlist input.tinvwl-button.alt',
		'element'  => 'border-radius',
		'text'     => __( 'Border Radius', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'       => 'group',
		'title'      => __( 'wrapped blocks', 'ti-woocommerce-wishlist-premium' ) . '<br/>' . __( '(create wishlist, search, login)', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-wrapped-block',
		'element'  => 'background-color',
		'text'     => __( 'Block Background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),

	array(
		'type'       => 'group',
		'title'      => __( 'Cart page buttons', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce-cart .tinv-wishlist .tinvwl_cart_to_wishlist_button,.tinv-wishlist .tinvwl_all_cart_to_wishlist_button',
		'element'  => 'background-color',
		'text'     => __( 'Background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce-cart .tinv-wishlist .tinvwl_cart_to_wishlist_button:hover,.tinv-wishlist.woocommerce .tinvwl_all_cart_to_wishlist_button:hover,.tinv-wishlist.woocommerce .tinvwl_cart_to_wishlist_button.tinvwl-product-in-list,.tinv-wishlist.woocommerce .tinvwl_all_cart_to_wishlist_button.tinvwl-product-in-list',
		'element'  => 'background-color',
		'text'     => __( 'Background Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce-cart .tinv-wishlist .tinvwl_cart_to_wishlist_button,.tinv-wishlist .tinvwl_all_cart_to_wishlist_button',
		'element'  => 'color',
		'text'     => __( 'Text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce-cart .tinv-wishlist .tinvwl_cart_to_wishlist_button:hover,.tinv-wishlist.woocommerce .tinvwl_all_cart_to_wishlist_button:hover,.tinv-wishlist.woocommerce .tinvwl_cart_to_wishlist_button.tinvwl-product-in-list,.tinv-wishlist.woocommerce .tinvwl_all_cart_to_wishlist_button.tinvwl-product-in-list',
		'element'  => 'color',
		'text'     => __( 'Text Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce-cart .tinv-wishlist .tinvwl_cart_to_wishlist_button:before',
		'element'  => 'color',
		'text'     => __( '"Save for Later" Icon Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.woocommerce-cart .tinv-wishlist .tinvwl_cart_to_wishlist_button:hover:before, .woocommerce-cart .tinv-wishlist .tinvwl_cart_to_wishlist_button.tinvwl-product-in-list:before',
		'element'  => 'color',
		'text'     => __( '"Save for Later" Icon Hover/Active Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinvwl_all_cart_to_wishlist_button:before',
		'element'  => 'color',
		'text'     => __( '"Save Cart" Icon Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinvwl_all_cart_to_wishlist_button:hover:before, .tinv-wishlist .tinvwl_all_cart_to_wishlist_button.tinvwl-product-in-list:before',
		'element'  => 'color',
		'text'     => __( '"Save Cart" Icon Hover/Active Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'       => 'group',
		'title'      => __( 'table', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist table tr',
		'element'  => 'border-color',
		'text'     => __( 'Border Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist table th',
		'element'  => 'background-color',
		'text'     => __( 'Table Head Background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist table th',
		'element'  => 'color',
		'text'     => __( 'Table Head Text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'select',
		'selector' => '.tinv-wishlist table th',
		'element'  => 'font-family',
		'text'     => __( 'Table Head Font', 'ti-woocommerce-wishlist-premium' ),
		'options'  => $font_family,
		'validate' => array( 'filter' => FILTER_DEFAULT ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist table th',
		'element'  => 'font-size',
		'text'     => __( 'Table Head Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist table td',
		'element'  => 'font-size',
		'text'     => __( 'Content Text Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist td.product-price',
		'element'  => 'color',
		'text'     => __( 'Price Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),

	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist td.product-price',
		'element'  => 'font-size',
		'text'     => __( 'Price Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist td.product-price ins span.amount',
		'element'  => 'color',
		'text'     => __( 'Special Price Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist td.product-price ins',
		'element'  => 'background-color',
		'text'     => __( 'Special Price Background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	/*array(
		'type'		 => 'color_important',
		'selector'	 => '.tinv-wishlist .social-buttons li a',
		'element'	 => 'background-color',
		'text'		 => __( 'Social Icons Background Color', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'		 => 'color_important',
		'selector'	 => '.tinv-wishlist .social-buttons li a:hover',
		'element'	 => 'background-color',
		'text'		 => __( 'Social Icons Background Hover Color', 'ti-woocommerce-wishlist-premium' ),
	),*/
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .social-buttons li a:before',
		'element'  => 'color',
		'text'     => __( 'Social Icons Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .social-buttons li a:hover:before',
		'element'  => 'color',
		'text'     => __( 'Social Icons Hover Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'       => 'group',
		'title'      => __( 'popups', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-modal .tinv-modal-inner',
		'element'  => 'background-color',
		'text'     => __( 'Popup Background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-overlay',
		'element'  => 'background-color',
		'text'     => __( 'Background Overlay Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'       => 'color_important',
		'selector'   => '.tinv-wishlist .tinv-modal-inner',
		'element'    => 'box-shadow',
		'subelement' => array( '-webkit-box-shadow', '-moz-box-shadow' ),
		'text'       => __( 'Popup Shadow Color', 'ti-woocommerce-wishlist-premium' ),
		'format'     => '0 16px 55px -20px {0}',
		'extra'      => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-modal h2',
		'element'  => 'color',
		'text'     => __( 'Title Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'select',
		'selector' => '.tinv-wishlist .tinv-modal h2',
		'element'  => 'font-family',
		'text'     => __( 'Title Font', 'ti-woocommerce-wishlist-premium' ),
		'options'  => $font_family,
		'validate' => array( 'filter' => FILTER_DEFAULT ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist .tinv-modal h2',
		'element'  => 'font-size',
		'text'     => __( 'Title Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-modal .tinv-modal-inner',
		'element'  => 'color',
		'text'     => __( 'Content Text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'select',
		'selector' => '.tinv-wishlist .tinv-modal .tinv-modal-inner a,.tinv-wishlist .tinv-modal .tinv-modal-inner,.tinv-wishlist .tinv-modal .tinv-modal-inner select',
		'element'  => 'font-family',
		'text'     => __( 'Content Text Font', 'ti-woocommerce-wishlist-premium' ),
		'options'  => $font_family,
		'validate' => array( 'filter' => FILTER_DEFAULT ),
	),
	array(
		'type'     => 'text',
		'selector' => '.tinv-wishlist .tinv-modal .tinv-modal-inner a,.tinv-wishlist .tinv-modal .tinv-modal-inner,.tinv-wishlist .tinv-modal .tinv-modal-inner select',
		'element'  => 'font-size',
		'text'     => __( 'Content Text Font Size', 'ti-woocommerce-wishlist-premium' ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.tinv-wishlist .tinv-modal .tinv-modal-inner input,.tinv-wishlist .tinv-modal .tinv-modal-inner select,.tinv-wishlist .tinv-modal .tinv-modal-inner textarea',
		'element'  => 'color',
		'text'     => __( 'Fields Text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'       => 'group',
		'title'      => __( 'Counter and Mini Wishlist', 'ti-woocommerce-wishlist-premium' ),
		'show_names' => true,
	),
	array(
		'type'     => 'color_important',
		'selector' => '.wishlist_products_counter .widget_wishlist',
		'element'  => 'background-color',
		'text'     => __( 'Drop down background Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'       => 'color_important',
		'selector'   => '.wishlist_products_counter .widget_wishlist',
		'element'    => 'box-shadow',
		'subelement' => array( '-webkit-box-shadow', '-moz-box-shadow' ),
		'text'       => __( 'Drop down shadow Color', 'ti-woocommerce-wishlist-premium' ),
		'format'     => '0 10px 80px -10px {0}',
		'extra'      => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.widget-area .widget .wishlist_products_counter,.wishlist_products_counter .widget_wishlist,.wishlist_products_counter',
		'element'  => 'color',
		'text'     => __( 'Mini wishlist text Color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.widget-area .widget .wishlist_products_counter .wishlist_products_counter_number,.wishlist_products_counter .wishlist_products_counter_number,.widget-area .widget .wishlist_products_counter .wishlist_products_counter_text,.wishlist_products_counter .wishlist_products_counter_text',
		'element'  => 'color',
		'text'     => __( 'Counter text color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),

	array(
		'type'     => 'select',
		'selector' => '.widget-area .widget .wishlist_products_counter,.wishlist_products_counter .widget_wishlist,.wishlist_products_counter',
		'element'  => 'font-family',
		'text'     => __( 'Font', 'ti-woocommerce-wishlist-premium' ),
		'options'  => $font_family,
		'validate' => array( 'filter' => FILTER_DEFAULT ),
	),
	array(
		'type'     => 'color_important',
		'selector' => 'div.wishlist_products_counter .wishlist_products_counter_wishlist.widget_wishlist ul.wishlist_list_titles li > a:hover,div.wishlist_products_counter .wishlist_products_counter_wishlist.widget_wishlist ul.wishlist_list_titles li > a',
		'element'  => 'color',
		'text'     => __( 'Wishlist tags color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => 'div.wishlist_products_counter .wishlist_products_counter_wishlist.widget_wishlist ul.wishlist_list_titles li > a:hover,div.wishlist_products_counter .wishlist_products_counter_wishlist.widget_wishlist ul.wishlist_list_titles li > a',
		'element'  => 'background-color',
		'text'     => __( 'Wishlists tag background color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.widget-area .widget .wishlist_products_counter .widget_wishlist a,.wishlist_products_counter .widget_wishlist a',
		'element'  => 'color',
		'text'     => __( 'Mini wishlist links color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => '.widget-area .widget .wishlist_products_counter .widget_wishlist a:hover,.wishlist_products_counter .widget_wishlist a:hover',
		'element'  => 'color',
		'text'     => __( 'Mini wishlist links hover color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => 'div.wishlist_products_counter.top_wishlist-font-icon i.wishlist-icon:before',
		'element'  => 'color',
		'text'     => __( 'Wishlist icon color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),
	array(
		'type'     => 'color_important',
		'selector' => 'div.wishlist_products_counter.top_wishlist-font-icon.wishlist-counter-with-products i.wishlist-icon:before',
		'element'  => 'color',
		'text'     => __( 'Wishlist active icon color', 'ti-woocommerce-wishlist-premium' ),
		'extra'    => array( 'important_label' => __( 'Important', 'ti-woocommerce-wishlist-premium' ) ),
	),

);
