<?php
/**
 * Phone Number Validation
 *
 * @link              https://w7s.dev
 * @since             1.0.0
 * @package           Phone_Number_Validation
 *
 * Plugin Name: Phone Number Validation
 * Plugin URI: https://woocommerce.com/product/phone-number-validation
 * Description: Validates international telephone numbers on WooCommerce billing addresses.
 * Author: w7s
 * Author URI: https://woocommerce.com/vendor/w7s/
 * Version: 1.6
 * Text Domain: phone-number-validation
 * Domain Path: /languages
 *
 * Requires at least: 6.0
 * Tested up to: 6.8.1
 * Requires PHP: 7.4
 * WC requires at least: 9.0
 * WC tested up to: 10.0.4
 * Requires Plugins: woocommerce
 *
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Woo: 18734004736341:defd23baaa10472fa1d03ae2a53d398c

 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Define plugin constants.
define( 'PNV_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'PNV_PLUGIN_FILE', __FILE__ );
define( 'PNV_PLUGIN_VERSION', '1.6' );

// Autoloader for plugin classes.
require_once PNV_PLUGIN_DIR . 'includes/class-loader.php';

// Initialize the plugin.
PNV\Phone_Number_Validation\Loader::get_instance()->init();
