/**
 * Admin Settings Script
 * Initializes enhanced select fields for the Phone Validation settings.
 *
 * @package    Phone_Number_Validation
 */

jQuery( document ).ready(
	function ($) {
		// Initialize WooCommerce enhanced select fields.
		$( '.wc-enhanced-select' ).select2(
			{
				allowClear: true,
				placeholder: function () {
					return $( this ).data( 'placeholder' ) || '';
				}
			}
		);

		/**
		 * Updates the Preferred Countries select options.
		 */
		function updatePreferredCountriesOptions() {
			var $preferredCountries = $( '#pnv_preferred_countries' );

			// Preserve current selected preferred countries.
			var selectedPreferred = $preferredCountries.val() || [];

			// Clear current options.
			$preferredCountries.empty();

			// Populate Preferred Countries with all countries.
			$.each(
				pnvAdminData.allCountries,
				function (code, name) {
					$preferredCountries.append(
						$('<option>', {
							value: code,
							text: name
						})
					);
				}
			);

			// Re-initialize Select2.
			$preferredCountries.select2(
				{
					allowClear: true,
					placeholder: $preferredCountries.data( 'placeholder' ) || ''
				}
			);

			// Restore previously selected Preferred Countries.
			if (selectedPreferred.length > 0) {
				$preferredCountries.val( selectedPreferred ).trigger( 'change.select2' );
			}
		}

		// Run the functions on page load.
		updatePreferredCountriesOptions();

		// Run the functions whenever Initial Country changes.
		$( '#pnv_initial_country' ).on(
			'change',
			function () {
				updatePreferredCountriesOptions();
			}
		);

		/**
		 * Toggle visibility of "Make Shipping Phone Required" based on "Add Shipping Phone Field"
		 */
		function toggleMakeShippingPhoneRequired() {
			var addShippingPhone   = $( '#pnv_add_shipping_phone' ).is( ':checked' );
			var $makeRequiredField = $( '#pnv_make_shipping_phone_required' ).closest( 'tr' );

			if ( addShippingPhone ) {
				$makeRequiredField.show();
			} else {
				$makeRequiredField.hide();
				// Optionally, uncheck the Make Shipping Phone Required checkbox if hiding.
				$( '#pnv_make_shipping_phone_required' ).prop( 'checked', false );
			}
		}

		// Initial toggle on page load.
		toggleMakeShippingPhoneRequired();

		// Toggle when "Add Shipping Phone Field" changes.
		$( '#pnv_add_shipping_phone' ).on(
			'change',
			function () {
				toggleMakeShippingPhoneRequired();
			}
		);
	}
);
