# Phone Number Validation for WooCommerce

![Phone Number Validation Banner](assets/img/w7s-phone-number-validation-banner.png)

## Overview

The [Phone Number Validation](https://woocommerce.com/product/phone-number-validation) plugin enhances your WooCommerce store by ensuring that customers provide valid and correctly formatted phone numbers during the checkout and account management processes. Leveraging the powerful [intl-tel-input](https://github.com/jackocnr/intl-tel-input) library supported by [Twilio](https://twilio.com/), this plugin offers robust validation, customizable settings, and seamless integration with both classic and block-based WooCommerce checkouts.

---

## Key Benefits

- **Enhanced Data Accuracy:** Ensures that all customer phone numbers are valid and correctly formatted, reducing errors in customer contact information.
- **Improved User Experience:** Provides real-time validation feedback, helping customers correct their phone numbers promptly.
- **Customization:** Offers extensive settings to tailor phone number validation according to your store’s requirements, including country restrictions and preferred formats.
- **Seamless Integration:** Works effortlessly with both classic and block-based WooCommerce checkouts, ensuring consistency across your store.
- **Developer-Friendly:** Built with clean, maintainable code adhering to WordPress and WooCommerce standards, making it easy to extend or modify.

---

## Features

- **Real-Time Phone Number Validation:** Validates phone numbers as customers input them, ensuring immediate feedback on correctness.
- **International Support:** Supports a wide range of countries with customizable initial, preferred, and excluded countries.
- **Separate Dial Code Display:** Option to show country codes and flags, enhancing the international shopping experience.
- **Shipping Phone Field:** Optionally add a separate phone number field for shipping addresses, with the ability to make it required.
- **Customizable Settings:** Comprehensive settings panel to configure validation rules, country selections, and more.
- **Compatibility with WooCommerce Blocks:** Fully compatible with WooCommerce’s block-based checkout system, ensuring modern and flexible layouts.
- **Debug Logging:** Option to enable debug logging for troubleshooting and monitoring phone validation processes.

---

## Requirements

Before installing the [Phone Number Validation](https://woocommerce.com/product/phone-number-validation) plugin, ensure that your environment meets the following requirements:

- **WordPress:** Version 6.0 or higher
- **WooCommerce:** Version 7.0 or higher
- **PHP:** Version 7.4 or higher
- **HTTPS:** Recommended for secure data transmission
- **`intl-tel-input` [Library](https://github.com/jackocnr/intl-tel-input):** Already included this plugin

---

## Installation

Follow these steps to install and activate the [Phone Number Validation](https://woocommerce.com/product/phone-number-validation) plugin on your WooCommerce store:

1. **Download the Plugin:**
   - Download the plugin zip file from the official WooCommerce marketplace after purchase.

2. **Upload to WordPress:**
   - Log in to your WordPress admin dashboard.
   - Navigate to `Plugins` > `Add New`.
   - Click on the `Upload Plugin` button.
   - Choose the plugin `.zip` file you downloaded and click `Install Now`.

3. **Activate the Plugin:**
   - After installation, click the `Activate Plugin` button.
   - The plugin is now active and ready for configuration.

4. **Configure Plugin Settings:**
   - Click one `Settings` to access the plugin's settings panel; OR
   - Navigate to `WooCommerce` > `Settings` > `Shipping` > `Phone Validation` to access the plugin’s settings panel.

---

## Usage

### Plugin Settings Overview

![Phone Number Validation Settings](assets/img/phone-number-validation-settings.jpg)

The **Phone Number Validation** plugin provides a comprehensive settings panel within the WooCommerce Shipping settings. Here’s an overview of the available settings:

1. **Add Shipping Phone Field:** Add a shipping phone number input field to the shipping form.

2. **Make Shipping Phone Required:** Require customers to enter a shipping phone number. If disabled, the field will be optional.

3. **Initial Country:** The initial country code displayed for customers without an account.
   - **Default:** `US`

4. **Supported Countries:** Select the country codes that are allowed. Leave blank to allow all countries. Must include the initial country when set.
   - **Default:** All countries allowed.

5. **Preferred Countries:** Countries that appear at the top of the dropdown list during checkout.
   - **Default:** `US`, `GB`

6. **Show Country Codes:** Display country codes and flags on the checkout phone field. Deselecting this checkbox only shows country flags.

7. **Allow Dropdown:** Allow users to select their country from a dropdown menu.

8. **Exclude Countries:** Select countries to exclude from the country dropdown.

9. **Enable Debug:** Enable debug logging for phone number validation. Debub logs found at `WooCommerce` > `Status` > `Logs`

---

### Classic Checkout

![Phone Number Validation Classic / Shortcode Checkout](assets/img/phone-number-validation-shortcode-new.jpg)

For stores using the classic WooCommerce checkout system, the **Phone Number Validation** plugin integrates seamlessly to enhance phone number fields. Here’s how it works:

1. **Enhanced Phone Fields:**
   - The billing phone field is augmented with country flags and validation mechanisms.
   - If enabled, a separate shipping phone field is added to the shipping address form.

2. **Real-Time Validation:**
   - As customers enter their phone numbers, the plugin validates the input in real-time, ensuring correctness.

3. **Error Notifications:**
   - If a phone number is invalid, an error message is displayed, and the customer is prompted to correct it before proceeding.

4. **Order Processing:**
   - Validated phone numbers are saved to the order metadata, ensuring accurate customer information.

---

### Block Checkout

![Phone Number Validation Block Checkout](assets/img/phone-number-validation-block-new.jpg)

For stores utilizing WooCommerce’s block-based checkout system, the **Phone Number Validation** plugin ensures compatibility and enhanced functionality:

1. **Integration with WooCommerce Blocks:**
   - The plugin detects block-based checkout pages and initializes phone number validation accordingly.

2. **Error Messaging:**
   - Each phone number field will show a dedicated notice on the exact nature of the error. Examples include:
    * Billing phone number has an invalid country code.
    * Billing phone number is too short.
    * Billing phone number is too long.
    * Billing phone is an invalid number.
   - If validation fails and the customer attempts to proceed, a checkout error message is displayed at the top of the checkout form.

4. **Disabling "Place Order" Button:**
   - The "Place Order" button is disabled until all phone numbers are correctly validated, preventing incomplete or incorrect orders.

---

## FAQ

### 1. **How do I enable the shipping phone field?**

Navigate to `WooCommerce` > `Settings` > `Shipping` > `Phone Validation`. Check the option **Add shipping phone field** and save your changes. You can also choose to make this field required by enabling the **Make shipping phone required** option.

### 2. **Can I restrict phone number validation to specific countries?**

Yes. In the plugin settings, you can specify **Supported Countries** to limit validation to certain countries. Additionally, you can set **Preferred Countries** to prioritize specific countries in the dropdown list and **Exclude Countries** to remove certain countries from the selection.

### 3. **How does the plugin handle international phone numbers?**

The plugin uses the `intl-tel-input` library to support international phone numbers. It displays country flags and allows users to select their country code from a dropdown. Phone numbers are validated based on the selected country, ensuring accurate formatting.

### 4. **What happens if a customer enters an invalid phone number?**

If an invalid phone number is detected during checkout, the plugin displays an error message prompting the customer to correct the number. In block-based checkouts, the "Place Order" button is disabled until the phone number is valid.

### 5. **Is debug logging available for troubleshooting?**

Yes. You can enable debug logging by checking the **Enable debug** option in the plugin settings. This will log phone validation processes, aiding in troubleshooting any issues that arise.

### 6. **Does the plugin support both classic and block-based WooCommerce checkouts?**

Yes. The plugin is designed to work seamlessly with both classic and block-based checkout systems, ensuring consistent validation and user experience across different WooCommerce setups.

### 7. **How can I customize the initial country displayed in the phone input field?**

In the plugin settings under **Initial Country**, select the desired country that should be displayed by default when customers access the checkout or account pages.

### 8. **Can I exclude specific countries from the phone number validation?**

Yes. Use the **Exclude Countries** setting to remove specific countries from the phone number validation dropdown, preventing customers from selecting them during checkout.

### 9. **Where are the validated phone numbers stored?**

Validated phone numbers are saved to the order metadata in WooCommerce. You can view them in the order details within the WooCommerce admin dashboard.

### 10. **Is the plugin compatible with other WooCommerce extensions?**

The plugin is built to adhere to WooCommerce standards, ensuring compatibility with most WooCommerce extensions. However, if you encounter any conflicts, please reach out to our support team for assistance.

### 11. **Is the plugin compatible with High Performance Order Storage (HPOS)?**

Yes. The plugin is designed to work seamlessly with both HPOS and traditional order storage.

---

For further assistance or to report any issues, please contact our support team page in your [WooCommerce account page](https://woocommerce.com/my-account/contact-support/).
