<?php
namespace WPO\WC\PDF_Invoices\Documents;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( !class_exists( '\\WPO\\WC\\PDF_Invoices\\Documents\\Pro_Document' ) ) :

/**
 * Pro Document abstract
 * 
 * @class       \WPO\WC\PDF_Invoices\Documents\Pro_Document
 * @version     2.0
 * @category    Class
 * @author      Ewout Fernhout
 */

abstract class Pro_Document extends Order_Document_Methods {

	public function use_historical_settings() {
		$document_settings = get_option( 'wpo_wcpdf_documents_settings_'.$this->get_type() );
		// this setting is inverted on the frontend so that it needs to be actively/purposely enabled to be used
		if (!empty($document_settings) && isset($document_settings['use_latest_settings'])) {
			$use_historical_settings = false;
		} else {
			$use_historical_settings = true;
		}
		return apply_filters( 'wpo_wcpdf_document_use_historical_settings', $use_historical_settings, $this );
	}

	public function storing_settings_enabled() {
		return apply_filters( 'wpo_wcpdf_document_store_settings', true, $this );
	}

	public function init() {
		if ( version_compare( WPO_WCPDF()->version, '3.2.0', '<' ) ) {
			// store settings in order
			if ( $this->storing_settings_enabled() && ! empty( $this->order ) ) {
				$common_settings   = WPO_WCPDF()->settings->get_common_document_settings();
				$document_settings = get_option( 'wpo_wcpdf_documents_settings_'.$this->get_type() );
				$settings          = (array) $document_settings + (array) $common_settings;
				$this->order->update_meta_data( "_wcpdf_{$this->slug}_settings", $settings );
				$this->order->save_meta_data();
			}
		} else {
			// init settings
			$this->init_settings_data();
			$this->save_settings();
		}

		if ( isset( $this->settings['display_date'] ) && $this->settings['display_date'] == 'order_date' && !empty( $this->order ) ) {
			$this->set_date( $this->order->get_date_created() );
		} elseif ( empty( $this->get_date() ) ) {
			$this->set_date( current_time( 'timestamp', true ) );
		}

		$this->init_number();
		
		do_action( 'wpo_wcpdf_init_document', $this );
	}

    public function exists() {
        return ! empty( $this->data['number'] );
    }

	public function init_number() {
		// if a third-party plugin claims to generate document numbers, trigger this instead
		if ( apply_filters( "woocommerce_{$this->slug}_number_by_plugin", false ) || apply_filters( "wpo_wcpdf_external_{$this->slug}_number_enabled", false, $this ) ) {
			$pro_document_number = apply_filters( "woocommerce_generate_{$this->slug}_number", null, $this->order );
			$pro_document_number = apply_filters( "wpo_wcpdf_external_{$this->slug}_number", $pro_document_number, $this );
		} elseif ( isset( $this->settings['display_number'] ) && $this->settings['display_number'] == 'order_number' && ! empty( $this->order ) ) {
			$pro_document_number = $this->order->get_order_number();
		}

		if ( ! empty( $pro_document_number ) ) { // overriden by plugin or set to order number
			if ( is_numeric( $pro_document_number ) || $pro_document_number instanceof Document_Number ) {
				$this->set_number( $pro_document_number );
			} else {
				// document number is not numeric, treat as formatted
				// try to extract meaningful number data
				$formatted_number    = $pro_document_number;
				$number              = (int) preg_replace( '/\D/', '', $pro_document_number );
				$pro_document_number = compact( 'number', 'formatted_number' );
				$this->set_number( $pro_document_number );
			}
			return $pro_document_number;
		}

		$number_store        = $this->get_sequential_number_store();
		$pro_document_number = $number_store->increment( intval( $this->order_id ), $this->get_date()->date_i18n( 'Y-m-d H:i:s' ) );

		$this->set_number( $pro_document_number );

		return $pro_document_number;
	}
	
	public function get_number_sequence( $number_store_name, $document ) {
		return isset( $document->settings['number_sequence'] ) ? $document->settings['number_sequence'] : "{$document->slug}_number";
	}

	public function get_formatted_number( $document_type ) {
		if ( $number = $this->get_number( $document_type ) ) {
			return $formatted_number = $number->get_formatted();
		} else {
			return '';
		}
	}

	public function number( $document_type ) {
		echo $this->get_formatted_number( $document_type );
	}

	public function get_formatted_date( $document_type ) {
		if ( $date = $this->get_date( $document_type ) ) {
			return $date->date_i18n( apply_filters( 'wpo_wcpdf_date_format', wc_date_format(), $this ) );
		} else {
			return '';
		}
	}

	public function date( $document_type ) {
		echo $this->get_formatted_date( $document_type );
	}


}

endif; // class_exists
